<?php
/**
 * Plugin Paths Helper
 *
 * Provides convenient methods for accessing plugin file paths,
 * URLs, and directory locations.
 *
 * @package Mamba\Support
 * @since   1.0.0
 */

namespace Mamba\Support;

/**
 * Class Paths
 *
 * Helper class for resolving plugin paths including base directory,
 * URLs, admin assets, views, and cache directory locations.
 *
 * @since 1.0.0
 */
final class Paths {
    public function __construct(private string $pluginFile) {}
    public function base(): string { return plugin_dir_path($this->pluginFile); }
    public function url(): string { return plugin_dir_url($this->pluginFile); }
    public function adminCss(string $file): string { return $this->url()."admin/css/{$file}"; }
    public function adminJs(string $file): string { return $this->url()."admin/js/{$file}"; }
    public function view(string $file): string { return $this->base()."resources/views/{$file}"; }
    public function moduleView(string $module, string $file): string { return $this->base()."src/Modules/{$module}/views/{$file}"; }
    public function cacheDir(): string { return WP_CONTENT_DIR . '/cache/mamba/'; }
}
