<?php
if (!defined('ABSPATH')) exit;

use Mamba\Support\Logger;

/** @var array $stats */
/** @var array $files */
/** @var bool $debugMode */
/** @var bool $loggingEnabled */
/** @var string $logLevel */
/** @var int $retentionDays */
?>

<div class="mamba-admin-wrap">
    <!-- Logs Overview -->
    <div class="mamba-form-section">
        <div class="mamba-section-header">
            <h4 class="mamba-section-title">
                <span class="dashicons dashicons-media-text"></span>
                <?php echo esc_html(__('Debug Logs & Monitoring', 'mamba-cache-for-woocommerce')); ?>
            </h4>
        </div>
        
        <div class="mamba-logs-overview">
            <div class="mamba-logs-overview-card">
                <div class="mamba-logs-overview-icon">
                    <span class="dashicons dashicons-visibility"></span>
                </div>
                <div class="mamba-logs-overview-content">
                    <h3 class="mamba-logs-overview-title"><?php echo esc_html(__('Cache Activity Monitor', 'mamba-cache-for-woocommerce')); ?></h3>
                    <p class="mamba-logs-overview-description">
                        <?php echo esc_html(__('Monitor cache events, invalidations, warmup activity, and troubleshoot issues. Enable debug mode for verbose logging during development or troubleshooting.', 'mamba-cache-for-woocommerce')); ?>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Log Statistics -->
    <div class="mamba-form-section">
        <div class="mamba-section-header">
            <h4 class="mamba-section-title">
                <span class="dashicons dashicons-chart-bar"></span>
                <?php echo esc_html(__('Log Statistics', 'mamba-cache-for-woocommerce')); ?>
            </h4>
        </div>
        
        <div class="mamba-stats-grid">
            <div class="mamba-stat-card">
                <div class="mamba-stat-icon dashicons dashicons-media-document"></div>
                <div class="mamba-stat-content">
                    <div class="mamba-stat-value"><?php echo esc_html($stats['total_files']); ?></div>
                    <div class="mamba-stat-label"><?php echo esc_html(__('Log Files', 'mamba-cache-for-woocommerce')); ?></div>
                </div>
            </div>
            
            <div class="mamba-stat-card">
                <div class="mamba-stat-icon dashicons dashicons-database"></div>
                <div class="mamba-stat-content">
                    <div class="mamba-stat-value"><?php echo esc_html($stats['total_size_human']); ?></div>
                    <div class="mamba-stat-label"><?php echo esc_html(__('Total Size', 'mamba-cache-for-woocommerce')); ?></div>
                </div>
            </div>
            
            <div class="mamba-stat-card">
                <div class="mamba-stat-icon dashicons dashicons-list-view"></div>
                <div class="mamba-stat-content">
                    <div class="mamba-stat-value"><?php echo esc_html(number_format_i18n($stats['total_entries'])); ?></div>
                    <div class="mamba-stat-label"><?php echo esc_html(__('Total Entries', 'mamba-cache-for-woocommerce')); ?></div>
                </div>
            </div>
            
            <div class="mamba-stat-card <?php echo esc_attr( $stats['by_level'][Logger::LEVEL_ERROR] > 0 ? 'has-errors' : '' ); ?>">
                <div class="mamba-stat-icon dashicons dashicons-warning"></div>
                <div class="mamba-stat-content">
                    <div class="mamba-stat-value"><?php echo esc_html($stats['by_level'][Logger::LEVEL_ERROR]); ?></div>
                    <div class="mamba-stat-label"><?php echo esc_html(__('Errors Today', 'mamba-cache-for-woocommerce')); ?></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Log Settings -->
    <div class="mamba-form-section">
        <div class="mamba-section-header">
            <h4 class="mamba-section-title">
                <span class="dashicons dashicons-admin-generic"></span>
                <?php echo esc_html(__('Log Settings', 'mamba-cache-for-woocommerce')); ?>
            </h4>
        </div>
        
        <div class="mamba-optimization-grid">
            <div class="mamba-optimization-item">
                <div class="mamba-optimization-header">
                    <div class="mamba-optimization-content">
                        <h5 class="mamba-optimization-name"><?php echo esc_html(__('Enable Logging', 'mamba-cache-for-woocommerce')); ?></h5>
                        <p class="mamba-optimization-description"><?php echo esc_html(__('Log cache events, invalidations, and system activity.', 'mamba-cache-for-woocommerce')); ?></p>
                    </div>
                </div>
                <div class="mamba-toggle-switch">
                    <input id="mamba_enable_logging" type="checkbox" <?php checked($loggingEnabled); ?> data-setting="logging_enabled" />
                    <label for="mamba_enable_logging"><?php echo esc_html(__('Enable', 'mamba-cache-for-woocommerce')); ?></label>
                </div>
            </div>
            
            <div class="mamba-optimization-item">
                <div class="mamba-optimization-header">
                    <div class="mamba-optimization-content">
                        <h5 class="mamba-optimization-name"><?php echo esc_html(__('Debug Mode', 'mamba-cache-for-woocommerce')); ?></h5>
                        <p class="mamba-optimization-description"><?php echo esc_html(__('Enable verbose logging for troubleshooting. Includes detailed request info and performance metrics.', 'mamba-cache-for-woocommerce')); ?></p>
                    </div>
                </div>
                <div class="mamba-toggle-switch">
                    <input id="mamba_debug_mode" type="checkbox" <?php checked($debugMode); ?> data-setting="debug_mode" />
                    <label for="mamba_debug_mode"><?php echo esc_html(__('Enable', 'mamba-cache-for-woocommerce')); ?></label>
                </div>
            </div>
            
            <div class="mamba-optimization-item">
                <div class="mamba-optimization-header">
                    <div class="mamba-optimization-content">
                        <h5 class="mamba-optimization-name"><?php echo esc_html(__('Log Level', 'mamba-cache-for-woocommerce')); ?></h5>
                        <p class="mamba-optimization-description"><?php echo esc_html(__('Minimum severity level to log. ERROR = critical only, DEBUG = everything.', 'mamba-cache-for-woocommerce')); ?></p>
                    </div>
                </div>
                <div class="mamba-setting-control">
                    <select id="mamba_log_level" data-setting="log_level" class="mamba-select">
                        <option value="ERROR" <?php selected($logLevel, 'ERROR'); ?>><?php echo esc_html(__('Error', 'mamba-cache-for-woocommerce')); ?></option>
                        <option value="WARNING" <?php selected($logLevel, 'WARNING'); ?>><?php echo esc_html(__('Warning', 'mamba-cache-for-woocommerce')); ?></option>
                        <option value="INFO" <?php selected($logLevel, 'INFO'); ?>><?php echo esc_html(__('Info (Recommended)', 'mamba-cache-for-woocommerce')); ?></option>
                        <option value="DEBUG" <?php selected($logLevel, 'DEBUG'); ?>><?php echo esc_html(__('Debug (Verbose)', 'mamba-cache-for-woocommerce')); ?></option>
                    </select>
                </div>
            </div>
            
            <div class="mamba-optimization-item">
                <div class="mamba-optimization-header">
                    <div class="mamba-optimization-content">
                        <h5 class="mamba-optimization-name"><?php echo esc_html(__('Log Retention', 'mamba-cache-for-woocommerce')); ?></h5>
                        <p class="mamba-optimization-description"><?php echo esc_html(__('Number of days to keep log files before automatic cleanup.', 'mamba-cache-for-woocommerce')); ?></p>
                    </div>
                </div>
                <div class="mamba-setting-control">
                    <select id="mamba_log_retention" data-setting="retention_days" class="mamba-select">
                        <option value="3" <?php selected($retentionDays, 3); ?>>3 <?php echo esc_html(__('days', 'mamba-cache-for-woocommerce')); ?></option>
                        <option value="7" <?php selected($retentionDays, 7); ?>>7 <?php echo esc_html(__('days (Recommended)', 'mamba-cache-for-woocommerce')); ?></option>
                        <option value="14" <?php selected($retentionDays, 14); ?>>14 <?php echo esc_html(__('days', 'mamba-cache-for-woocommerce')); ?></option>
                        <option value="30" <?php selected($retentionDays, 30); ?>>30 <?php echo esc_html(__('days', 'mamba-cache-for-woocommerce')); ?></option>
                    </select>
                </div>
            </div>
        </div>
        
        <div class="mamba-form-actions-inline">
            <button type="button" id="mamba-save-log-settings" class="mamba-save-button">
                <span class="dashicons dashicons-saved"></span>
                <?php echo esc_html(__('Save Settings', 'mamba-cache-for-woocommerce')); ?>
            </button>
        </div>
    </div>

    <!-- Log Viewer -->
    <div class="mamba-form-section">
        <div class="mamba-section-header">
            <h4 class="mamba-section-title">
                <span class="dashicons dashicons-editor-code"></span>
                <?php echo esc_html(__('Log Viewer', 'mamba-cache-for-woocommerce')); ?>
            </h4>
            
            <div class="mamba-log-actions">
                <select id="mamba-log-date" class="mamba-select-small">
                    <option value=""><?php echo esc_html(__('Today', 'mamba-cache-for-woocommerce')); ?></option>
                    <?php foreach ($files as $file): ?>
                        <option value="<?php echo esc_attr($file['date']); ?>">
                            <?php echo esc_html($file['date'] . ' (' . $file['size_human'] . ')'); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                
                <select id="mamba-log-level-filter" class="mamba-select-small">
                    <option value=""><?php echo esc_html(__('All Levels', 'mamba-cache-for-woocommerce')); ?></option>
                    <option value="ERROR"><?php echo esc_html(__('Errors', 'mamba-cache-for-woocommerce')); ?></option>
                    <option value="WARNING"><?php echo esc_html(__('Warnings', 'mamba-cache-for-woocommerce')); ?></option>
                    <option value="INFO"><?php echo esc_html(__('Info', 'mamba-cache-for-woocommerce')); ?></option>
                    <option value="DEBUG"><?php echo esc_html(__('Debug', 'mamba-cache-for-woocommerce')); ?></option>
                </select>
                
                <button type="button" id="mamba-refresh-logs" class="mamba-action-button-secondary">
                    <span class="dashicons dashicons-update"></span>
                    <?php echo esc_html(__('Refresh', 'mamba-cache-for-woocommerce')); ?>
                </button>
            </div>
        </div>
        
        <div id="mamba-log-viewer" class="mamba-log-viewer">
            <div class="mamba-log-loading">
                <span class="dashicons dashicons-update spin"></span>
                <?php echo esc_html(__('Loading logs...', 'mamba-cache-for-woocommerce')); ?>
            </div>
        </div>
        
        <div id="mamba-log-pagination" class="mamba-log-pagination" style="display: none;">
            <button type="button" id="mamba-load-more" class="mamba-action-button-secondary">
                <?php echo esc_html(__('Load More', 'mamba-cache-for-woocommerce')); ?>
            </button>
            <span id="mamba-log-count" class="mamba-log-count"></span>
        </div>
    </div>

    <!-- Export & Maintenance -->
    <div class="mamba-form-section">
        <div class="mamba-section-header">
            <h4 class="mamba-section-title">
                <span class="dashicons dashicons-download"></span>
                <?php echo esc_html(__('Export & Maintenance', 'mamba-cache-for-woocommerce')); ?>
            </h4>
        </div>
        
        <div class="mamba-export-grid">
            <div class="mamba-export-card">
                <div class="mamba-export-icon dashicons dashicons-download"></div>
                <div class="mamba-export-content">
                    <h5><?php echo esc_html(__('Export Logs for Support', 'mamba-cache-for-woocommerce')); ?></h5>
                    <p><?php echo esc_html(__('Download logs with system info, server configuration, and plugin diagnostics for troubleshooting or priority support requests.', 'mamba-cache-for-woocommerce')); ?></p>
                    <div class="mamba-export-controls">
                        <select id="mamba-export-days" class="mamba-select-small">
                            <option value="1">1 <?php echo esc_html(__('day', 'mamba-cache-for-woocommerce')); ?></option>
                            <option value="3" selected>3 <?php echo esc_html(__('days', 'mamba-cache-for-woocommerce')); ?></option>
                            <option value="7">7 <?php echo esc_html(__('days', 'mamba-cache-for-woocommerce')); ?></option>
                        </select>
                        <button type="button" id="mamba-export-logs" class="mamba-action-button-primary">
                            <span class="dashicons dashicons-download"></span>
                            <?php echo esc_html(__('Export', 'mamba-cache-for-woocommerce')); ?>
                        </button>
                    </div>
                </div>
            </div>
            
            <div class="mamba-export-card mamba-export-danger">
                <div class="mamba-export-icon dashicons dashicons-trash"></div>
                <div class="mamba-export-content">
                    <h5><?php echo esc_html(__('Clear All Logs', 'mamba-cache-for-woocommerce')); ?></h5>
                    <p><?php echo esc_html(__('Permanently delete all log files. This action cannot be undone.', 'mamba-cache-for-woocommerce')); ?></p>
                    <button type="button" id="mamba-clear-logs" class="mamba-action-button-danger">
                        <span class="dashicons dashicons-trash"></span>
                        <?php echo esc_html(__('Clear Logs', 'mamba-cache-for-woocommerce')); ?>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
ob_start();
?>
/* Logs Overview Section */
.mamba-logs-overview {
    margin-bottom: 20px;
}

.mamba-logs-overview-card {
    display: flex;
    align-items: center;
    gap: 20px;
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    padding: 20px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    width: 100%;
    max-width: -webkit-fill-available;
}

.mamba-logs-overview-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
}

.mamba-logs-overview-icon {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 48px;
    height: 48px;
    border-radius: 8px;
    background: linear-gradient(135deg, #E68057 0%, #E6704D 100%);
    box-shadow: 0 2px 8px rgba(230, 128, 87, 0.2);
}

.mamba-logs-overview-icon .dashicons {
    font-size: 20px;
    width: 20px;
    height: 20px;
    color: #ffffff;
}

.mamba-logs-overview-content {
    flex: 1;
}

.mamba-logs-overview-title {
    margin: 0 0 6px 0;
    font-size: 16px;
    font-weight: 500;
    color: var(--mamba-dark);
}

.mamba-logs-overview-description {
    margin: 0;
    color: var(--mamba-muted);
    line-height: 1.4;
    font-size: 13px;
}

/* Stats Grid */
.mamba-stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
    gap: 16px;
    margin-bottom: 20px;
}

.mamba-stat-card {
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    padding: 16px;
    display: flex;
    align-items: center;
    gap: 12px;
    transition: all 0.3s ease;
}

.mamba-stat-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.mamba-stat-card.has-errors {
    border-color: #fca5a5;
    background: #fef2f2;
}

.mamba-stat-icon {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    border-radius: 8px;
    background: linear-gradient(135deg, #f1f5f9 0%, #e2e8f0 100%);
    color: #64748b;
    font-size: 18px;
}

.mamba-stat-card.has-errors .mamba-stat-icon {
    background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
    color: #dc2626;
}

.mamba-stat-content {
    flex: 1;
}

.mamba-stat-value {
    font-size: 20px;
    font-weight: 600;
    color: var(--mamba-dark);
    line-height: 1.2;
}

.mamba-stat-label {
    font-size: 12px;
    color: var(--mamba-muted);
    margin-top: 2px;
}

/* Log Viewer */
.mamba-log-viewer {
    background: #1e293b;
    border-radius: 8px;
    padding: 16px;
    min-height: 300px;
    max-height: 500px;
    overflow-y: auto;
    font-family: var(--mamba-font-mono, 'SF Mono', Monaco, monospace);
    font-size: 12px;
    line-height: 1.6;
}

.mamba-log-loading {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    color: #94a3b8;
    padding: 40px;
}

.mamba-log-loading .dashicons {
    animation: spin 1s linear infinite;
}

@keyframes spin {
    from { transform: rotate(0deg); }
    to { transform: rotate(360deg); }
}

.mamba-log-entry {
    padding: 8px 12px;
    border-radius: 4px;
    margin-bottom: 4px;
    background: rgba(255, 255, 255, 0.03);
    border-left: 3px solid transparent;
}

.mamba-log-entry.level-error {
    border-left-color: #ef4444;
    background: rgba(239, 68, 68, 0.1);
}

.mamba-log-entry.level-warning {
    border-left-color: #f59e0b;
    background: rgba(245, 158, 11, 0.1);
}

.mamba-log-entry.level-info {
    border-left-color: #3b82f6;
    background: rgba(59, 130, 246, 0.1);
}

.mamba-log-entry.level-debug {
    border-left-color: #8b5cf6;
    background: rgba(139, 92, 246, 0.1);
}

.mamba-log-time {
    color: #64748b;
    font-size: 11px;
}

.mamba-log-level {
    display: inline-block;
    padding: 2px 6px;
    border-radius: 3px;
    font-size: 10px;
    font-weight: 600;
    text-transform: uppercase;
    margin: 0 8px;
}

.mamba-log-level.level-error { background: #ef4444; color: #fff; }
.mamba-log-level.level-warning { background: #f59e0b; color: #fff; }
.mamba-log-level.level-info { background: #3b82f6; color: #fff; }
.mamba-log-level.level-debug { background: #8b5cf6; color: #fff; }

.mamba-log-message {
    color: #e2e8f0;
}

.mamba-log-context {
    margin-top: 4px;
    padding: 8px;
    background: rgba(0, 0, 0, 0.2);
    border-radius: 4px;
    font-size: 11px;
    color: #94a3b8;
    white-space: pre-wrap;
    word-break: break-all;
}

.mamba-log-empty {
    text-align: center;
    color: #64748b;
    padding: 40px;
}

/* Log Actions */
.mamba-log-actions {
    display: flex;
    align-items: center;
    gap: 8px;
}

.mamba-select-small {
    padding: 6px 10px;
    border: 1px solid #d1d5db;
    border-radius: 4px;
    font-size: 12px;
    background: #fff;
}

.mamba-action-button-secondary {
    display: inline-flex;
    align-items: center;
    gap: 4px;
    padding: 6px 12px;
    background: #f1f5f9;
    border: 1px solid #e2e8f0;
    border-radius: 4px;
    font-size: 12px;
    font-weight: 500;
    color: #475569;
    cursor: pointer;
    transition: all 0.2s ease;
}

.mamba-action-button-secondary:hover {
    background: #e2e8f0;
    border-color: #cbd5e1;
}

.mamba-action-button-secondary .dashicons {
    font-size: 14px;
    width: 14px;
    height: 14px;
}

/* Export Section */
.mamba-export-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 16px;
}

@media (max-width: 900px) {
    .mamba-export-grid {
        grid-template-columns: 1fr;
    }
}

.mamba-export-card {
    display: flex;
    align-items: flex-start;
    gap: 16px;
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    padding: 20px;
    transition: all 0.3s ease;
}

.mamba-export-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.mamba-export-card.mamba-export-danger {
    border-color: #fca5a5;
}

.mamba-export-card.mamba-export-danger:hover {
    box-shadow: 0 4px 12px rgba(239, 68, 68, 0.15);
}

.mamba-export-icon {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    border-radius: 8px;
    background: linear-gradient(135deg, #E68057 0%, #E6704D 100%);
    color: #fff;
    font-size: 18px;
}

.mamba-export-card.mamba-export-danger .mamba-export-icon {
    background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
}

.mamba-export-content {
    flex: 1;
}

.mamba-export-content h5 {
    margin: 0 0 6px 0;
    font-size: 14px;
    font-weight: 500;
    color: var(--mamba-dark);
}

.mamba-export-content p {
    margin: 0 0 12px 0;
    font-size: 12px;
    color: var(--mamba-muted);
    line-height: 1.4;
}

.mamba-export-controls {
    display: flex;
    align-items: center;
    gap: 8px;
}

.mamba-action-button {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 8px 14px;
    background: linear-gradient(135deg, #E68057 0%, #E6704D 100%);
    border: none;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 500;
    color: #fff;
    cursor: pointer;
    transition: all 0.2s ease;
}

.mamba-action-button:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(230, 128, 87, 0.3);
}

.mamba-action-button .dashicons {
    font-size: 14px;
    width: 14px;
    height: 14px;
}

.mamba-action-button-danger {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 8px 14px;
    background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
    border: none;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 500;
    color: #fff;
    cursor: pointer;
    transition: all 0.2s ease;
}

.mamba-action-button-danger:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(239, 68, 68, 0.3);
}

.mamba-action-button-danger .dashicons {
    font-size: 14px;
    width: 14px;
    height: 14px;
}

/* Form Actions Inline */
.mamba-form-actions-inline {
    margin-top: 20px;
    padding-top: 16px;
    border-top: 1px solid #e5e7eb;
}

/* Load More Button */
#mamba-load-more {
    display: block;
    width: 100%;
    padding: 12px;
    margin-top: 12px;
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 6px;
    color: #94a3b8;
    font-size: 13px;
    cursor: pointer;
    transition: all 0.2s ease;
}

#mamba-load-more:hover {
    background: rgba(255, 255, 255, 0.1);
    color: #e2e8f0;
}

/* Dark Mode Overrides */
[data-mamba-theme="dark"] .mamba-logs-overview-card,
[data-mamba-theme="dark"] .mamba-stat-card,
[data-mamba-theme="dark"] .mamba-export-card {
    background: var(--mamba-card);
    border-color: var(--mamba-border);
}

[data-mamba-theme="dark"] .mamba-stat-icon {
    background: linear-gradient(135deg, #334155 0%, #475569 100%);
    color: #94a3b8;
}

[data-mamba-theme="dark"] .mamba-select-small {
    background: var(--mamba-input-bg);
    border-color: var(--mamba-input-border);
    color: var(--mamba-text-main);
}

[data-mamba-theme="dark"] .mamba-action-button-secondary {
    background: #334155;
    border-color: #475569;
    color: #e2e8f0;
}

[data-mamba-theme="dark"] .mamba-action-button-secondary:hover {
    background: #475569;
}
<?php
$__tab_css = ob_get_clean();
wp_register_style('mamba-tab-logs-inline', false);
wp_enqueue_style('mamba-tab-logs-inline');
wp_add_inline_style('mamba-tab-logs-inline', $__tab_css);
wp_print_styles(['mamba-tab-logs-inline']);
?>
