<?php

if ( !defined( 'ABSPATH' ) ) {
    exit;
}
// Handle form submissions
if ( isset( $_POST['mamba_overhead_nonce'] ) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['mamba_overhead_nonce'] ) ), 'mamba_overhead' ) ) {
    update_option( 'mamba_disable_wc_assets_on_non_wc', ( isset( $_POST['mamba_disable_wc_assets_on_non_wc'] ) ? 1 : 0 ) );
    update_option( 'mamba_simplify_price_html', ( isset( $_POST['mamba_simplify_price_html'] ) ? 1 : 0 ) );
    update_option( 'mamba_enable_hover_prefetch', ( isset( $_POST['mamba_enable_hover_prefetch'] ) ? 1 : 0 ) );
    // Checkout optimization settings (Premium only)
    if ( function_exists( 'mamba_fs' ) && mamba_fs()->can_use_premium_code__premium_only() ) {
        update_option( 'mamba_optimize_checkout_js', ( isset( $_POST['mamba_optimize_checkout_js'] ) ? 1 : 0 ) );
        update_option( 'mamba_optimize_checkout_css', ( isset( $_POST['mamba_optimize_checkout_css'] ) ? 1 : 0 ) );
        update_option( 'mamba_disable_checkout_fragments', ( isset( $_POST['mamba_disable_checkout_fragments'] ) ? 1 : 0 ) );
        update_option( 'mamba_lazy_load_payments', ( isset( $_POST['mamba_lazy_load_payments'] ) ? 1 : 0 ) );
        update_option( 'mamba_defer_transactional_emails', ( isset( $_POST['mamba_defer_transactional_emails'] ) ? 1 : 0 ) );
        update_option( 'mamba_preconnect_payment_sdks', ( isset( $_POST['mamba_preconnect_payment_sdks'] ) ? 1 : 0 ) );
    }
    // HTML/CSS/JS Minification settings
    $prev_minify = (bool) get_option( 'mamba_enable_html_minify', 0 );
    $prev_mode = (string) get_option( 'mamba_html_minify_mode', 'conservative' );
    $now_minify = isset( $_POST['mamba_enable_html_minify'] );
    $now_mode = ( isset( $_POST['mamba_html_minify_mode'] ) ? sanitize_text_field( wp_unslash( $_POST['mamba_html_minify_mode'] ) ) : 'conservative' );
    // Aggressive mode is premium-only - force conservative for free users
    if ( $now_mode === 'aggressive' && (!function_exists( 'mamba_fs' ) || !mamba_fs()->can_use_premium_code__premium_only()) ) {
        $now_mode = 'conservative';
    }
    update_option( 'mamba_enable_html_minify', ( $now_minify ? 1 : 0 ) );
    update_option( 'mamba_html_minify_mode', ( in_array( $now_mode, ['conservative', 'aggressive'], true ) ? $now_mode : 'conservative' ) );
    // Critical CSS settings (Free: inlining + defer, Premium: custom CSS per page type)
    update_option( 'mamba_enable_critical_css', ( isset( $_POST['mamba_enable_critical_css'] ) ? 1 : 0 ) );
    update_option( 'mamba_enable_css_defer', ( isset( $_POST['mamba_enable_css_defer'] ) ? 1 : 0 ) );
    update_option( 'mamba_css_defer_all', ( isset( $_POST['mamba_css_defer_all'] ) ? 1 : 0 ) );
    if ( function_exists( 'mamba_fs' ) && mamba_fs()->can_use_premium_code__premium_only() ) {
        // Save custom CSS per page type
        $pageTypes = [
            'product',
            'shop',
            'category',
            'cart',
            'checkout',
            'account',
            'generic'
        ];
        foreach ( $pageTypes as $pageType ) {
            $fieldName = 'mamba_critical_css_custom_' . $pageType;
            if ( isset( $_POST[$fieldName] ) ) {
                update_option( $fieldName, wp_strip_all_tags( wp_unslash( $_POST[$fieldName] ) ) );
            }
        }
        // Save force-include selectors
        if ( isset( $_POST['mamba_critical_css_force_include'] ) ) {
            update_option( 'mamba_critical_css_force_include', sanitize_textarea_field( wp_unslash( $_POST['mamba_critical_css_force_include'] ) ) );
        }
    }
    // Clear critical CSS cache when settings change
    if ( class_exists( 'Mamba\\Modules\\CriticalCss\\Services\\CriticalCssManager' ) ) {
        $manager = new \Mamba\Modules\CriticalCss\Services\CriticalCssManager();
        $manager->clearCache();
    }
    // WooCommerce admin optimization (selected items removed)
    update_option( 'mamba_disable_order_attribution', ( isset( $_POST['mamba_disable_order_attribution'] ) ? 1 : 0 ) );
    // Font Preloading (Premium only)
    if ( function_exists( 'mamba_fs' ) && mamba_fs()->can_use_premium_code__premium_only() ) {
        update_option( 'mamba_enable_font_preload', ( isset( $_POST['mamba_enable_font_preload'] ) ? 1 : 0 ) );
        $fontUrls = ( isset( $_POST['mamba_preload_fonts'] ) ? sanitize_textarea_field( wp_unslash( $_POST['mamba_preload_fonts'] ) ) : '' );
        update_option( 'mamba_preload_fonts', $fontUrls );
    }
    // DNS Prefetch
    update_option( 'mamba_enable_dns_prefetch', ( isset( $_POST['mamba_enable_dns_prefetch'] ) ? 1 : 0 ) );
    $dnsDomains = ( isset( $_POST['mamba_dns_prefetch_domains'] ) ? sanitize_textarea_field( wp_unslash( $_POST['mamba_dns_prefetch_domains'] ) ) : '' );
    update_option( 'mamba_dns_prefetch_domains', $dnsDomains );
    // Preconnect External Domains (Premium only)
    if ( function_exists( 'mamba_fs' ) && mamba_fs()->can_use_premium_code__premium_only() ) {
        update_option( 'mamba_enable_preconnect', ( isset( $_POST['mamba_enable_preconnect'] ) ? 1 : 0 ) );
        $preconnectDomains = ( isset( $_POST['mamba_preconnect_domains'] ) ? sanitize_textarea_field( wp_unslash( $_POST['mamba_preconnect_domains'] ) ) : '' );
        update_option( 'mamba_preconnect_domains', $preconnectDomains );
    }
    // Heartbeat Control
    $heartbeatFrontend = ( isset( $_POST['mamba_heartbeat_frontend'] ) ? sanitize_text_field( wp_unslash( $_POST['mamba_heartbeat_frontend'] ) ) : 'default' );
    $heartbeatAdmin = ( isset( $_POST['mamba_heartbeat_admin'] ) ? sanitize_text_field( wp_unslash( $_POST['mamba_heartbeat_admin'] ) ) : 'default' );
    $heartbeatEditor = ( isset( $_POST['mamba_heartbeat_editor'] ) ? sanitize_text_field( wp_unslash( $_POST['mamba_heartbeat_editor'] ) ) : 'default' );
    update_option( 'mamba_heartbeat_frontend', ( in_array( $heartbeatFrontend, [
        'default',
        'disable',
        'slow',
        'very_slow'
    ], true ) ? $heartbeatFrontend : 'default' ) );
    update_option( 'mamba_heartbeat_admin', ( in_array( $heartbeatAdmin, [
        'default',
        'disable',
        'slow',
        'very_slow'
    ], true ) ? $heartbeatAdmin : 'default' ) );
    update_option( 'mamba_heartbeat_editor', ( in_array( $heartbeatEditor, [
        'default',
        'disable',
        'slow',
        'very_slow'
    ], true ) ? $heartbeatEditor : 'default' ) );
    // JavaScript Delay settings (Premium only)
    if ( function_exists( 'mamba_fs' ) && mamba_fs()->can_use_premium_code__premium_only() ) {
        update_option( 'mamba_enable_js_delay', ( isset( $_POST['mamba_enable_js_delay'] ) ? 1 : 0 ) );
        $jsDelayTimeout = ( isset( $_POST['mamba_js_delay_timeout'] ) ? absint( wp_unslash( $_POST['mamba_js_delay_timeout'] ) ) : 5000 );
        update_option( 'mamba_js_delay_timeout', max( 1000, min( 30000, $jsDelayTimeout ) ) );
        if ( isset( $_POST['mamba_js_delay_scripts'] ) ) {
            update_option( 'mamba_js_delay_scripts', sanitize_textarea_field( wp_unslash( $_POST['mamba_js_delay_scripts'] ) ) );
        }
        if ( isset( $_POST['mamba_js_delay_exclusions'] ) ) {
            update_option( 'mamba_js_delay_exclusions', sanitize_textarea_field( wp_unslash( $_POST['mamba_js_delay_exclusions'] ) ) );
        }
    }
    echo '<div class="notice notice-success"><p>' . esc_html( __( 'Overhead optimization settings saved successfully.', 'mamba-cache-for-woocommerce' ) ) . '</p></div>';
}
// Get current settings
$disableWcOnNon = (bool) get_option( 'mamba_disable_wc_assets_on_non_wc', 0 );
$simplifyPrice = (bool) get_option( 'mamba_simplify_price_html', 0 );
$enableHoverPrefetch = (bool) get_option( 'mamba_enable_hover_prefetch', 0 );
// HTML/CSS/JS Minification current values
$enableMinify = (bool) get_option( 'mamba_enable_html_minify', 0 );
$minifyMode = (string) get_option( 'mamba_html_minify_mode', 'conservative' );
// Critical CSS current values
$enableCriticalCss = (bool) get_option( 'mamba_enable_critical_css', 0 );
$enableCssDefer = (bool) get_option( 'mamba_enable_css_defer', 0 );
$cssDeferAll = (bool) get_option( 'mamba_css_defer_all', 0 );
$forceIncludeSelectors = get_option( 'mamba_critical_css_force_include', '' );
// Checkout optimization settings
$optimizeCheckoutJS = (bool) get_option( 'mamba_optimize_checkout_js', 0 );
$optimizeCheckoutCSS = (bool) get_option( 'mamba_optimize_checkout_css', 0 );
$disableCheckoutFragments = (bool) get_option( 'mamba_disable_checkout_fragments', 0 );
$lazyLoadPayments = (bool) get_option( 'mamba_lazy_load_payments', 0 );
$deferTransactionalEmails = (bool) get_option( 'mamba_defer_transactional_emails', 0 );
$preconnectPaymentSDKs = (bool) get_option( 'mamba_preconnect_payment_sdks', 0 );
$disableOrderAttribution = (bool) get_option( 'mamba_disable_order_attribution', 0 );
// Font Preloading
$enableFontPreload = (bool) get_option( 'mamba_enable_font_preload', 0 );
$preloadFonts = get_option( 'mamba_preload_fonts', '' );
// DNS Prefetch
$enableDnsPrefetch = (bool) get_option( 'mamba_enable_dns_prefetch', 0 );
$dnsPrefetchDomains = get_option( 'mamba_dns_prefetch_domains', '' );
// Preconnect External Domains
$enablePreconnect = (bool) get_option( 'mamba_enable_preconnect', 0 );
$preconnectDomains = get_option( 'mamba_preconnect_domains', '' );
// Heartbeat Control
$heartbeatFrontend = get_option( 'mamba_heartbeat_frontend', 'default' );
$heartbeatAdmin = get_option( 'mamba_heartbeat_admin', 'default' );
$heartbeatEditor = get_option( 'mamba_heartbeat_editor', 'default' );
// JavaScript Delay settings
$enableJsDelay = (bool) get_option( 'mamba_enable_js_delay', 0 );
$jsDelayTimeout = (int) get_option( 'mamba_js_delay_timeout', 5000 );
$jsDelayScripts = get_option( 'mamba_js_delay_scripts', '' );
$jsDelayExclusions = get_option( 'mamba_js_delay_exclusions', '' );
?>

<div class="mamba-admin-wrap">
    <!-- Premium Performance Overview -->
    <div class="mamba-form-section">
        <div class="mamba-section-header">
            <h4 class="mamba-section-title">
                <span class="dashicons dashicons-performance"></span>
                <?php 
echo esc_html( __( 'Performance Optimization Overview', 'mamba-cache-for-woocommerce' ) );
?>
            </h4>
        </div>
        
        <div class="mamba-performance-overview">
            <div class="mamba-performance-card">
                <div class="mamba-performance-icon">
                    <span class="dashicons dashicons-chart-line"></span>
                </div>
                <div class="mamba-performance-content">
                    <h3 class="mamba-performance-title"><?php 
echo esc_html( __( 'Overhead Reduction', 'mamba-cache-for-woocommerce' ) );
?></h3>
                    <p class="mamba-performance-description">
                        <?php 
echo esc_html( __( 'Optimize your WooCommerce store by removing unnecessary overhead, improving page load times, and enhancing user experience across all areas.', 'mamba-cache-for-woocommerce' ) );
?>
                    </p>
                </div>
            </div>
        </div>
        
    </div>

    <form method="post" class="mamba-overhead-form">
        <?php 
wp_nonce_field( 'mamba_overhead', 'mamba_overhead_nonce' );
?>

        <!-- HTML/CSS/JS Minification Section -->
        <div class="mamba-form-section">
            <div class="mamba-section-header">
                <h4 class="mamba-section-title">
                    <span class="dashicons dashicons-admin-appearance"></span>
                    <?php 
echo esc_html( __( 'HTML/CSS/JS Minification', 'mamba-cache-for-woocommerce' ) );
?>
                </h4>
            </div>
            <div class="mamba-optimization-intro">
                <p class="mamba-optimization-description">
                    <?php 
echo esc_html( __( 'Minify page HTML and (optionally) inline CSS/JS to reduce payload size and improve render times. Conservative mode minifies HTML only (safest). Aggressive mode also compresses inline CSS/JS and text nodes for additional savings; test with your theme, checkout and widgets.', 'mamba-cache-for-woocommerce' ) );
?>
                </p>
            </div>
            <div class="mamba-optimization-grid">
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-icon dashicons dashicons-performance"></div>
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php 
echo esc_html( __( 'Enable HTML/CSS/JS Minification', 'mamba-cache-for-woocommerce' ) );
?></h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'When enabled, Mamba minifies HTML for public pages. If page cache is ON, minification happens during cache build; changing this setting clears the page cache and triggers a warmup so all pages are rebuilt with the selected mode.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <div class="mamba-toggle-switch">
                        <input id="mamba_enable_html_minify" type="checkbox" name="mamba_enable_html_minify" <?php 
checked( $enableMinify );
?> />
                        <label for="mamba_enable_html_minify"><?php 
echo esc_html( __( 'Enable', 'mamba-cache-for-woocommerce' ) );
?></label>
                    </div>
                </div>

                <div id="mamba_minify_mode_item" class="mamba-optimization-item<?php 
echo esc_attr( ( !$enableMinify ? ' mamba-disabled' : '' ) );
?>">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-icon dashicons dashicons-admin-generic"></div>
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name">
                                <?php 
echo esc_html( __( 'Minification Mode', 'mamba-cache-for-woocommerce' ) );
?>
                                <?php 
?>
                                    <span class="mamba-premium-badge" style="font-size: 10px; margin-left: 6px;"><?php 
echo esc_html( __( 'Aggressive: Premium', 'mamba-cache-for-woocommerce' ) );
?></span>
                                <?php 
?>
                            </h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Choose Conservative (HTML-only) or Aggressive (HTML + inline CSS/JS). Aggressive mode is a Premium feature.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <div class="mamba-setting-control">
                        <select name="mamba_html_minify_mode" class="mamba-select" <?php 
disabled( !$enableMinify );
?>>
                            <option value="conservative" <?php 
selected( $minifyMode, 'conservative' );
?>><?php 
echo esc_html( __( 'Conservative (Recommended)', 'mamba-cache-for-woocommerce' ) );
?></option>
                            <?php 
?>
                        </select>
                    </div>
                </div>
            </div>
        </div>

        <!-- Critical CSS Optimization Section -->
        <div class="mamba-form-section">
            <div class="mamba-section-header">
                <h4 class="mamba-section-title">
                    <span class="dashicons dashicons-art"></span>
                    <?php 
echo esc_html( __( 'Critical CSS Optimization', 'mamba-cache-for-woocommerce' ) );
?>
                </h4>
            </div>
            <div class="mamba-optimization-intro">
                <p class="mamba-optimization-description">
                    <?php 
echo esc_html( __( 'Inline critical above-the-fold CSS to eliminate render-blocking resources and improve Core Web Vitals (LCP, FCP). Mamba includes pre-built critical CSS optimized for WooCommerce page types.', 'mamba-cache-for-woocommerce' ) );
?>
                </p>
            </div>
            <div class="mamba-optimization-grid">
                <!-- Critical CSS Inlining (Free - basic reset only) -->
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-icon dashicons dashicons-editor-code"></div>
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php 
echo esc_html( __( 'Enable Critical CSS Inlining', 'mamba-cache-for-woocommerce' ) );
?></h5>
                            <?php 
?>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Inject basic CSS reset inline in the page head. Upgrade to Pro for full WooCommerce-optimized critical CSS (product, shop, category, cart, checkout pages).', 'mamba-cache-for-woocommerce' ) );
?></p>
                            <?php 
?>
                        </div>
                    </div>
                    <div class="mamba-toggle-switch">
                        <input id="mamba_enable_critical_css" type="checkbox" name="mamba_enable_critical_css" <?php 
checked( $enableCriticalCss );
?> />
                        <label for="mamba_enable_critical_css"><?php 
echo esc_html( __( 'Enable', 'mamba-cache-for-woocommerce' ) );
?></label>
                    </div>
                </div>
                
                <!-- WooCommerce-Optimized CSS (Premium) -->
                <?php 
?>
                <div class="mamba-optimization-item" style="opacity: 0.7;">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-icon dashicons dashicons-cart"></div>
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name">
                                <?php 
echo esc_html( __( 'WooCommerce-Optimized Critical CSS', 'mamba-cache-for-woocommerce' ) );
?>
                                <span class="mamba-premium-badge"><?php 
echo esc_html( __( 'Premium', 'mamba-cache-for-woocommerce' ) );
?></span>
                            </h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Pre-built critical CSS optimized for WooCommerce page types: Product, Shop, Category, Cart, Checkout, and Account pages.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <div class="mamba-toggle-switch">
                        <input type="checkbox" disabled />
                        <label><?php 
echo esc_html( __( 'Included with Pro', 'mamba-cache-for-woocommerce' ) );
?></label>
                    </div>
                </div>
                <?php 
?>

                <!-- Defer Non-Critical CSS (Free) -->
                <div class="mamba-optimization-item<?php 
echo esc_attr( ( !$enableCriticalCss ? ' mamba-disabled' : '' ) );
?>">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-icon dashicons dashicons-clock"></div>
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php 
echo esc_html( __( 'Defer Non-Critical CSS', 'mamba-cache-for-woocommerce' ) );
?></h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Load non-critical stylesheets asynchronously after the page renders. Uses the media="print" technique with automatic fallback for no-JS users.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <div class="mamba-toggle-switch">
                        <input id="mamba_enable_css_defer" type="checkbox" name="mamba_enable_css_defer" <?php 
checked( $enableCssDefer );
?> <?php 
disabled( !$enableCriticalCss );
?> />
                        <label for="mamba_enable_css_defer"><?php 
echo esc_html( __( 'Enable', 'mamba-cache-for-woocommerce' ) );
?></label>
                    </div>
                </div>

                <div class="mamba-optimization-item<?php 
echo esc_attr( ( !$enableCriticalCss || !$enableCssDefer ? ' mamba-disabled' : '' ) );
?>">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-icon dashicons dashicons-admin-generic"></div>
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php 
echo esc_html( __( 'Defer All Stylesheets', 'mamba-cache-for-woocommerce' ) );
?></h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Defer all stylesheets except critical ones. More aggressive but may require testing with your theme.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <div class="mamba-toggle-switch">
                        <input id="mamba_css_defer_all" type="checkbox" name="mamba_css_defer_all" <?php 
checked( $cssDeferAll );
?> <?php 
disabled( !$enableCriticalCss || !$enableCssDefer );
?> />
                        <label for="mamba_css_defer_all"><?php 
echo esc_html( __( 'Enable', 'mamba-cache-for-woocommerce' ) );
?></label>
                    </div>
                </div>

                <!-- Force-Include Selectors (Premium) -->
                <?php 
?>
                <div class="mamba-optimization-item" style="opacity: 0.7;">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-icon dashicons dashicons-admin-generic"></div>
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name">
                                <?php 
echo esc_html( __( 'Custom Critical CSS per Page Type', 'mamba-cache-for-woocommerce' ) );
?>
                                <span class="mamba-premium-badge"><?php 
echo esc_html( __( 'Premium', 'mamba-cache-for-woocommerce' ) );
?></span>
                            </h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Add your own critical CSS rules for each WooCommerce page type (product, shop, category, cart, checkout).', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <div class="mamba-toggle-switch">
                        <input type="checkbox" disabled />
                        <label><?php 
echo esc_html( __( 'Enable', 'mamba-cache-for-woocommerce' ) );
?></label>
                    </div>
                </div>
                <?php 
?>
            </div>
            
            <?php 
if ( $enableCriticalCss ) {
    ?>
            <div class="mamba-critical-css-info" style="margin-top: 16px; padding: 12px 16px; background: rgba(16, 185, 129, 0.08); border: 1px solid rgba(16, 185, 129, 0.2); border-radius: 6px;">
                <p style="margin: 0; font-size: 13px; color: #065f46;">
                    <span class="dashicons dashicons-yes-alt" style="color: #10b981; font-size: 16px; vertical-align: middle; margin-right: 4px;"></span>
                    <?php 
    ?>
                    <strong><?php 
    echo esc_html( __( 'Active:', 'mamba-cache-for-woocommerce' ) );
    ?></strong>
                    <?php 
    echo esc_html( __( 'Basic CSS Reset (Upgrade to Pro for WooCommerce-optimized CSS)', 'mamba-cache-for-woocommerce' ) );
    ?>
                    <?php 
    ?>
                </p>
            </div>
            <?php 
}
?>
        </div>

        <!-- JavaScript Delay Section -->
        <div class="mamba-form-section">
            <div class="mamba-section-header">
                <h4 class="mamba-section-title">
                    <span class="dashicons dashicons-clock"></span>
                    <?php 
echo esc_html( __( 'JavaScript Delay', 'mamba-cache-for-woocommerce' ) );
?>
                    <?php 
?>
                        <span class="mamba-premium-badge"><?php 
echo esc_html( __( 'Premium', 'mamba-cache-for-woocommerce' ) );
?></span>
                    <?php 
?>
                </h4>
            </div>
            
            <div class="mamba-optimization-intro">
                <p class="mamba-optimization-description">
                    <?php 
echo esc_html( __( 'Delay non-critical JavaScript execution until user interaction (mouse move, scroll, click, touch). This significantly improves Core Web Vitals scores (INP, TBT, FCP) by removing scripts from the initial page load.', 'mamba-cache-for-woocommerce' ) );
?>
                </p>
            </div>
            
            <?php 
?>
                <div class="mamba-premium-upsell">
                    <div class="mamba-upsell-content">
                        <span class="dashicons dashicons-lock"></span>
                        <h5><?php 
echo esc_html( __( 'Boost Core Web Vitals', 'mamba-cache-for-woocommerce' ) );
?></h5>
                        <p><?php 
echo esc_html( __( 'JavaScript Delay defers non-critical scripts (analytics, tracking, chat widgets) until user interaction, significantly improving INP, TBT, and page load times.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        <a href="<?php 
echo esc_url( mamba_fs()->get_upgrade_url() );
?>" class="button button-primary mamba-upgrade-btn">
                            <?php 
echo esc_html( __( 'Upgrade to Pro', 'mamba-cache-for-woocommerce' ) );
?>
                        </a>
                    </div>
                </div>
            <?php 
?>
        </div>

        <!-- Checkout Optimization Section -->
        <div class="mamba-form-section">
            <div class="mamba-section-header">
                <h4 class="mamba-section-title">
                    <span class="dashicons dashicons-cart"></span>
                    <?php 
echo esc_html( __( 'Checkout Optimization', 'mamba-cache-for-woocommerce' ) );
?>
                    <?php 
?>
                        <span class="mamba-premium-badge"><?php 
echo esc_html( __( 'Premium', 'mamba-cache-for-woocommerce' ) );
?></span>
                    <?php 
?>
                </h4>
            </div>
            
            <div class="mamba-optimization-intro">
                <p class="mamba-optimization-description">
                    <?php 
echo esc_html( __( 'Optimize the checkout process to reduce page load times and improve conversion rates. These settings focus on deferring non-critical resources while maintaining full functionality.', 'mamba-cache-for-woocommerce' ) );
?>
                </p>
            </div>
            
            <?php 
?>
                <div class="mamba-premium-upsell">
                    <div class="mamba-upsell-content">
                        <span class="dashicons dashicons-lock"></span>
                        <h5><?php 
echo esc_html( __( 'Increase Checkout Conversions', 'mamba-cache-for-woocommerce' ) );
?></h5>
                        <p><?php 
echo esc_html( __( '6 checkout optimizations: defer non-critical JS, optimize CSS, smart cart fragments, lazy-load payment gateways (Stripe, PayPal, etc.), defer transactional emails, and preconnect to 15+ payment SDKs.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        <a href="<?php 
echo esc_url( mamba_fs()->get_upgrade_url() );
?>" class="button button-primary mamba-upgrade-btn">
                            <?php 
echo esc_html( __( 'Upgrade to Pro', 'mamba-cache-for-woocommerce' ) );
?>
                        </a>
                    </div>
                </div>
            <?php 
?>
        </div>

        <!-- User-facing Optimization Section (Free) -->
        <div class="mamba-form-section">
            <div class="mamba-section-header">
                <h4 class="mamba-section-title">
                    <span class="dashicons dashicons-admin-site"></span>
                    <?php 
echo esc_html( __( 'User-facing Optimization', 'mamba-cache-for-woocommerce' ) );
?>
                </h4>
            </div>
            
            <div class="mamba-optimization-intro">
                <p class="mamba-optimization-description">
                    <?php 
echo esc_html( __( 'Optimize the frontend experience by removing unnecessary assets, simplifying markup, and improving navigation speed across your entire site.', 'mamba-cache-for-woocommerce' ) );
?>
                </p>
            </div>
            
            <div class="mamba-optimization-grid mamba-frontend-grid">
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-icon dashicons dashicons-admin-appearance"></div>
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php 
echo esc_html( __( 'Dequeue WooCommerce Assets', 'mamba-cache-for-woocommerce' ) );
?></h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Remove all WooCommerce CSS/JS on non-WooCommerce pages to reduce page load time.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <div class="mamba-toggle-switch">
                        <input id="mamba_disable_wc_assets_on_non_wc" type="checkbox" name="mamba_disable_wc_assets_on_non_wc" <?php 
checked( $disableWcOnNon );
?> />
                        <label for="mamba_disable_wc_assets_on_non_wc"><?php 
echo esc_html( __( 'Enable', 'mamba-cache-for-woocommerce' ) );
?></label>
                    </div>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-icon dashicons dashicons-editor-paste-text"></div>
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php 
echo esc_html( __( 'Simplify Price HTML', 'mamba-cache-for-woocommerce' ) );
?></h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Replace currency markup, remove bdi/screen-reader spans for cleaner HTML.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <div class="mamba-toggle-switch">
                        <input id="mamba_simplify_price_html" type="checkbox" name="mamba_simplify_price_html" <?php 
checked( $simplifyPrice );
?> />
                        <label for="mamba_simplify_price_html"><?php 
echo esc_html( __( 'Enable', 'mamba-cache-for-woocommerce' ) );
?></label>
                    </div>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-icon dashicons dashicons-admin-links"></div>
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php 
echo esc_html( __( 'Enable Hover Prefetch', 'mamba-cache-for-woocommerce' ) );
?></h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Prefetch likely next pages on hover/touch for faster navigation and improved perceived speed.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <div class="mamba-toggle-switch">
                        <input id="mamba_enable_hover_prefetch" type="checkbox" name="mamba_enable_hover_prefetch" <?php 
checked( $enableHoverPrefetch );
?> />
                        <label for="mamba_enable_hover_prefetch"><?php 
echo esc_html( __( 'Enable', 'mamba-cache-for-woocommerce' ) );
?></label>
                    </div>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-icon dashicons dashicons-chart-bar"></div>
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php 
echo esc_html( __( 'Disable Order Attribution', 'mamba-cache-for-woocommerce' ) );
?></h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Remove order attribution script on browsing pages for faster loading.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <div class="mamba-toggle-switch">
                        <input id="mamba_disable_order_attribution" type="checkbox" name="mamba_disable_order_attribution" <?php 
checked( $disableOrderAttribution );
?> />
                        <label for="mamba_disable_order_attribution"><?php 
echo esc_html( __( 'Enable', 'mamba-cache-for-woocommerce' ) );
?></label>
                    </div>
                </div>
            </div>
        </div>

        <!-- Resource Hints Section (Free) -->
        <div class="mamba-form-section">
            <div class="mamba-section-header">
                <h4 class="mamba-section-title">
                    <span class="dashicons dashicons-admin-links"></span>
                    <?php 
echo esc_html( __( 'Resource Hints & Preloading', 'mamba-cache-for-woocommerce' ) );
?>
                </h4>
            </div>
            
            <div class="mamba-optimization-intro">
                <p class="mamba-optimization-description">
                    <?php 
echo esc_html( __( 'Optimize resource loading by preloading critical assets, prefetching DNS lookups, and preconnecting to external domains.', 'mamba-cache-for-woocommerce' ) );
?>
                </p>
            </div>
            
            <div class="mamba-optimization-grid">
                <!-- Font Preloading (Premium) -->
                <?php 
?>
                <div class="mamba-optimization-item mamba-optimization-item-full" style="opacity: 0.7;">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-icon dashicons dashicons-editor-textcolor"></div>
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name">
                                <?php 
echo esc_html( __( 'Font Preloading', 'mamba-cache-for-woocommerce' ) );
?>
                                <span class="mamba-premium-badge"><?php 
echo esc_html( __( 'Premium', 'mamba-cache-for-woocommerce' ) );
?></span>
                            </h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Preload critical fonts to reduce render-blocking and improve LCP. Enter full URLs to font files (WOFF2 recommended).', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <div class="mamba-toggle-switch" style="margin-bottom: 12px;">
                        <input id="mamba_enable_font_preload" type="checkbox" disabled />
                        <label for="mamba_enable_font_preload"><?php 
echo esc_html( __( 'Enable', 'mamba-cache-for-woocommerce' ) );
?></label>
                    </div>
                    <div class="mamba-textarea-control">
                        <textarea id="mamba_preload_fonts" rows="3" placeholder="https://example.com/fonts/font.woff2&#10;https://example.com/fonts/font-bold.woff2" disabled></textarea>
                        <p class="mamba-field-hint"><?php 
echo esc_html( __( 'One font URL per line. Supports WOFF2, WOFF, TTF, OTF formats.', 'mamba-cache-for-woocommerce' ) );
?></p>
                    </div>
                </div>
                <?php 
?>
                
                <!-- DNS Prefetch -->
                <div class="mamba-optimization-item mamba-optimization-item-full">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-icon dashicons dashicons-networking"></div>
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php 
echo esc_html( __( 'DNS Prefetch', 'mamba-cache-for-woocommerce' ) );
?></h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Resolve DNS for external domains early to reduce latency.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <div class="mamba-toggle-switch" style="margin-bottom: 12px;">
                        <input id="mamba_enable_dns_prefetch" type="checkbox" name="mamba_enable_dns_prefetch" <?php 
checked( $enableDnsPrefetch );
?> />
                        <label for="mamba_enable_dns_prefetch"><?php 
echo esc_html( __( 'Enable', 'mamba-cache-for-woocommerce' ) );
?></label>
                    </div>
                    
                    <?php 
if ( $enableDnsPrefetch ) {
    ?>
                    <div class="mamba-auto-detected-domains" style="background: rgba(16, 185, 129, 0.08); border: 1px solid rgba(16, 185, 129, 0.2); border-radius: 6px; padding: 12px; margin-bottom: 12px;">
                        <p style="margin: 0 0 8px; font-size: 12px; font-weight: 600; color: #065f46;">
                            <span class="dashicons dashicons-yes-alt" style="color: #10b981; font-size: 14px; vertical-align: middle;"></span>
                            <?php 
    echo esc_html( __( 'Auto-detected domains (always included):', 'mamba-cache-for-woocommerce' ) );
    ?>
                        </p>
                        <div style="display: flex; flex-wrap: wrap; gap: 6px;">
                            <?php 
    $autoDetectedDomains = [
        'fonts.googleapis.com',
        'fonts.gstatic.com',
        'www.google-analytics.com',
        'www.googletagmanager.com',
        'connect.facebook.net',
        'cdnjs.cloudflare.com',
        'cdn.jsdelivr.net'
    ];
    if ( function_exists( 'WC' ) ) {
        $autoDetectedDomains = array_merge( $autoDetectedDomains, ['js.stripe.com', 'www.paypal.com'] );
    }
    foreach ( $autoDetectedDomains as $domain ) {
        ?>
                                <span style="background: #fff; border: 1px solid #d1fae5; border-radius: 4px; padding: 2px 8px; font-size: 11px; color: #047857; font-family: monospace;"><?php 
        echo esc_html( $domain );
        ?></span>
                            <?php 
    }
    ?>
                        </div>
                    </div>
                    <?php 
}
?>
                    
                    <div class="mamba-textarea-control">
                        <textarea id="mamba_dns_prefetch_domains" name="mamba_dns_prefetch_domains" rows="3" placeholder="cdn.example.com&#10;api.thirdparty.com"><?php 
echo esc_textarea( $dnsPrefetchDomains );
?></textarea>
                        <p class="mamba-field-hint"><?php 
echo esc_html( __( 'Add custom domains to prefetch (one per line). These will be added to the auto-detected list above.', 'mamba-cache-for-woocommerce' ) );
?></p>
                    </div>
                </div>
                
                <!-- Preconnect External Domains (Premium) -->
                <?php 
?>
                <div class="mamba-optimization-item mamba-optimization-item-full" style="opacity: 0.7;">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-icon dashicons dashicons-admin-site-alt3"></div>
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name">
                                <?php 
echo esc_html( __( 'Preconnect External Domains', 'mamba-cache-for-woocommerce' ) );
?>
                                <span class="mamba-premium-badge"><?php 
echo esc_html( __( 'Premium', 'mamba-cache-for-woocommerce' ) );
?></span>
                            </h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Establish early connections (DNS + TCP + TLS) to critical third-party origins. Separate from payment SDK preconnects.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <div class="mamba-toggle-switch" style="margin-bottom: 12px;">
                        <input id="mamba_enable_preconnect" type="checkbox" disabled />
                        <label for="mamba_enable_preconnect"><?php 
echo esc_html( __( 'Enable', 'mamba-cache-for-woocommerce' ) );
?></label>
                    </div>
                    <div class="mamba-textarea-control">
                        <textarea id="mamba_preconnect_domains" rows="3" placeholder="https://cdn.example.com&#10;https://api.service.com" disabled></textarea>
                        <p class="mamba-field-hint"><?php 
echo esc_html( __( 'Full URLs with protocol (https://). One per line.', 'mamba-cache-for-woocommerce' ) );
?></p>
                    </div>
                </div>
                <?php 
?>
            </div>
        </div>

        <!-- Heartbeat Control Section (Free) -->
        <div class="mamba-form-section">
            <div class="mamba-section-header">
                <h4 class="mamba-section-title">
                    <span class="dashicons dashicons-heart"></span>
                    <?php 
echo esc_html( __( 'WordPress Heartbeat Control', 'mamba-cache-for-woocommerce' ) );
?>
                </h4>
            </div>
            
            <div class="mamba-optimization-intro">
                <p class="mamba-optimization-description">
                    <?php 
echo esc_html( __( 'Control the WordPress Heartbeat API frequency to reduce server load and improve admin performance. The Heartbeat API handles auto-saves, post locking, and real-time notifications.', 'mamba-cache-for-woocommerce' ) );
?>
                </p>
            </div>
            
            <div class="mamba-optimization-grid">
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-icon dashicons dashicons-admin-home"></div>
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php 
echo esc_html( __( 'Frontend Heartbeat', 'mamba-cache-for-woocommerce' ) );
?></h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Heartbeat on public pages. Usually not needed - disable for best performance.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <div class="mamba-setting-control">
                        <select name="mamba_heartbeat_frontend" class="mamba-select">
                            <option value="default" <?php 
selected( $heartbeatFrontend, 'default' );
?>><?php 
echo esc_html( __( 'Default (15s)', 'mamba-cache-for-woocommerce' ) );
?></option>
                            <option value="slow" <?php 
selected( $heartbeatFrontend, 'slow' );
?>><?php 
echo esc_html( __( 'Slow (60s)', 'mamba-cache-for-woocommerce' ) );
?></option>
                            <option value="very_slow" <?php 
selected( $heartbeatFrontend, 'very_slow' );
?>><?php 
echo esc_html( __( 'Very Slow (120s)', 'mamba-cache-for-woocommerce' ) );
?></option>
                            <option value="disable" <?php 
selected( $heartbeatFrontend, 'disable' );
?>><?php 
echo esc_html( __( 'Disable (Recommended)', 'mamba-cache-for-woocommerce' ) );
?></option>
                        </select>
                    </div>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-icon dashicons dashicons-dashboard"></div>
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php 
echo esc_html( __( 'Admin Dashboard Heartbeat', 'mamba-cache-for-woocommerce' ) );
?></h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Heartbeat in wp-admin (excluding editor). Reduce to lower server load.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <div class="mamba-setting-control">
                        <select name="mamba_heartbeat_admin" class="mamba-select">
                            <option value="default" <?php 
selected( $heartbeatAdmin, 'default' );
?>><?php 
echo esc_html( __( 'Default (15s)', 'mamba-cache-for-woocommerce' ) );
?></option>
                            <option value="slow" <?php 
selected( $heartbeatAdmin, 'slow' );
?>><?php 
echo esc_html( __( 'Slow (60s)', 'mamba-cache-for-woocommerce' ) );
?></option>
                            <option value="very_slow" <?php 
selected( $heartbeatAdmin, 'very_slow' );
?>><?php 
echo esc_html( __( 'Very Slow (120s)', 'mamba-cache-for-woocommerce' ) );
?></option>
                            <option value="disable" <?php 
selected( $heartbeatAdmin, 'disable' );
?>><?php 
echo esc_html( __( 'Disable', 'mamba-cache-for-woocommerce' ) );
?></option>
                        </select>
                    </div>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-icon dashicons dashicons-edit"></div>
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php 
echo esc_html( __( 'Post Editor Heartbeat', 'mamba-cache-for-woocommerce' ) );
?></h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Heartbeat in post/page editor. Needed for auto-save and post locking.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <div class="mamba-setting-control">
                        <select name="mamba_heartbeat_editor" class="mamba-select">
                            <option value="default" <?php 
selected( $heartbeatEditor, 'default' );
?>><?php 
echo esc_html( __( 'Default (15s)', 'mamba-cache-for-woocommerce' ) );
?></option>
                            <option value="slow" <?php 
selected( $heartbeatEditor, 'slow' );
?>><?php 
echo esc_html( __( 'Slow (60s) - Recommended', 'mamba-cache-for-woocommerce' ) );
?></option>
                            <option value="very_slow" <?php 
selected( $heartbeatEditor, 'very_slow' );
?>><?php 
echo esc_html( __( 'Very Slow (120s)', 'mamba-cache-for-woocommerce' ) );
?></option>
                            <option value="disable" <?php 
selected( $heartbeatEditor, 'disable' );
?>><?php 
echo esc_html( __( 'Disable (Not Recommended)', 'mamba-cache-for-woocommerce' ) );
?></option>
                        </select>
                    </div>
                </div>
            </div>
        </div>

        <!-- Information Section -->
        <div class="mamba-form-section">
            <div class="mamba-section-header">

            </div>
            
            <div class="mamba-info-cards">
                <div class="mamba-info-card">
                    <div class="mamba-info-icon dashicons dashicons-chart-line"></div>
                    <h5 class="mamba-info-title"><?php 
echo esc_html( __( 'Performance Impact', 'mamba-cache-for-woocommerce' ) );
?></h5>
                    <p class="mamba-info-description"><?php 
echo esc_html( __( 'These optimizations can improve page load times by 20-50% and reduce server overhead significantly.', 'mamba-cache-for-woocommerce' ) );
?></p>
                </div>
                
                <div class="mamba-info-card">
                    <div class="mamba-info-icon dashicons dashicons-shield"></div>
                    <h5 class="mamba-info-title"><?php 
echo esc_html( __( 'Safe & Tested', 'mamba-cache-for-woocommerce' ) );
?></h5>
                    <p class="mamba-info-description"><?php 
echo esc_html( __( 'All optimizations are carefully tested and only remove unnecessary overhead while preserving functionality.', 'mamba-cache-for-woocommerce' ) );
?></p>
                </div>
                
                <div class="mamba-info-card">
                    <div class="mamba-info-icon dashicons dashicons-admin-appearance"></div>
                    <h5 class="mamba-info-title"><?php 
echo esc_html( __( 'User Experience', 'mamba-cache-for-woocommerce' ) );
?></h5>
                    <p class="mamba-info-description"><?php 
echo esc_html( __( 'Faster loading times improve user experience, reduce bounce rates, and can increase conversion rates.', 'mamba-cache-for-woocommerce' ) );
?></p>
                </div>
            </div>
        </div>

        <!-- Form Actions -->
            <div class="mamba-form-actions">
            <button type="submit" class="mamba-save-button">
                <span class="dashicons dashicons-saved"></span>
                <?php 
echo esc_html( __( 'Save Optimization Settings', 'mamba-cache-for-woocommerce' ) );
?>
            </button>
        </div>
    </form>
</div>

<?php 
ob_start();
?>

/* Performance Overview Section */
.mamba-performance-overview {
    margin-bottom: 30px;
}

.mamba-performance-card {
    display: flex;
    align-items: center;
    gap: 20px;
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    padding: 20px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    width: 100%;
    max-width: -webkit-fill-available;
}

.mamba-performance-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
}

.mamba-performance-icon {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 48px;
    height: 48px;
    border-radius: 8px;
    background: linear-gradient(135deg, #E68057 0%, #E6704D 100%);
    box-shadow: 0 2px 8px rgba(230, 128, 87, 0.2);
}

.mamba-performance-icon .dashicons {
    font-size: 20px;
    width: 20px;
    height: 20px;
    color: #ffffff;
}

.mamba-performance-content {
    flex: 1;
}

.mamba-performance-title {
    margin: 0 0 6px 0;
    font-size: 16px;
    font-weight: 500;
    color: var(--mamba-dark);
}

.mamba-performance-description {
    margin: 0;
    color: var(--mamba-muted);
    line-height: 1.4;
    font-size: 13px;
}

/* Optimization Sections */
.mamba-optimization-intro {
    margin-bottom: 20px;
}

.mamba-optimization-description {
    margin: 0;
    color: var(--mamba-muted);
    font-size: 13px;
    line-height: 1.4;
}

.mamba-optimization-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
    gap: 16px;
    margin: 20px 0;
}

.mamba-frontend-grid {
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
}

.mamba-optimization-item {
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    padding: 16px;
    transition: all 0.3s ease;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
}

.mamba-optimization-item:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.mamba-optimization-header {
    display: flex;
    align-items: center;
    gap: 10px;
    margin-bottom: 12px;
}

.mamba-optimization-icon {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 32px;
    height: 32px;
    border-radius: 6px;
    background: linear-gradient(135deg, #E68057 0%, #E6704D 100%);
    color: #ffffff;
    font-size: 14px;
}

.mamba-optimization-content {
    flex: 1;
}

.mamba-optimization-name {
    margin: 0 0 4px 0;
    font-size: 13px;
    font-weight: 500;
    color: var(--mamba-dark);
}

.mamba-optimization-description {
    margin: 0;
    font-size: 11px;
    color: var(--mamba-muted);
    line-height: 1.3;
}

/* Toggle Switch Styling */
.mamba-toggle-switch {
    display: flex;
    align-items: center;
    justify-content: flex-end;
}

.mamba-toggle-switch input[type="checkbox"] {
    display: none;
}

.mamba-toggle-switch label {
    position: relative;
    padding-left: 40px;
    cursor: pointer;
    font-weight: 500;
    color: var(--mamba-text);
    font-size: 12px;
    user-select: none;
}

.mamba-toggle-switch label::before {
    content: '';
    position: absolute;
    left: 0;
    top: 50%;
    transform: translateY(-50%);
    width: 32px;
    height: 16px;
    background: linear-gradient(135deg, #e5e7eb 0%, #d1d5db 100%);
    border-radius: 4px;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    box-shadow: inset 0 1px 2px rgba(0, 0, 0, 0.1);
}

.mamba-toggle-switch label::after {
    content: '';
    position: absolute;
    left: 2px;
    top: 50%;
    transform: translateY(-50%);
    width: 12px;
    height: 12px;
    background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
    border-radius: 3px;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

.mamba-toggle-switch input[type="checkbox"]:checked + label::before {
    background: linear-gradient(135deg, #E68057 0%, #E6704D 100%);
    box-shadow: inset 0 2px 4px rgba(230, 128, 87, 0.2);
}

.mamba-toggle-switch input[type="checkbox"]:checked + label::after {
    transform: translate(16px, -50%);
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.15);
}

/* Info Cards */
.mamba-info-cards {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 16px;
    margin: 20px 0;
}

.mamba-info-card {
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    padding: 16px;
    text-align: center;
    transition: all 0.3s ease;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
}

.mamba-info-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.mamba-info-icon {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    border-radius: 8px;
    background: linear-gradient(135deg, #E68057 0%, #E6704D 100%);
    color: #ffffff;
    font-size: 16px;
    margin-bottom: 10px;
}

.mamba-info-title {
    margin: 0 0 6px 0;
    font-size: 12px;
    font-weight: 500;
    color: var(--mamba-dark);
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.mamba-info-description {
    margin: 0;
    font-size: 11px;
    color: var(--mamba-muted);
    line-height: 1.3;
}

/* Form Actions */
.mamba-form-actions {
    display: flex;
    justify-content: center;
    padding: 24px 0;
    border-top: 1px solid #f1f5f9;
    margin-top: 24px;
    gap: 10px;
}

.mamba-save-button {
    display: flex;
    align-items: center;
    gap: 6px;
    padding: 10px 20px;
    background: linear-gradient(135deg, #E68057 0%, #E6704D 100%);
    border: none;
    border-radius: 6px;
    color: #ffffff;
    font-size: 13px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 2px 8px rgba(230, 128, 87, 0.2);
}

.mamba-save-button:hover {
    background: linear-gradient(135deg, #d45a3a 0%, #c24a2a 100%);
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(230, 128, 87, 0.3);
}

.mamba-save-button .dashicons {
    font-size: 14px;
    width: 14px;
    height: 14px;
}

/* Disabled block state for minification mode */
.mamba-disabled {
    opacity: 0.5;
    pointer-events: none;
}

/* Full-width optimization items (for textareas) */
.mamba-optimization-item-full {
    grid-column: 1 / -1;
}

/* Textarea controls */
.mamba-textarea-control {
    margin-top: 8px;
}

.mamba-textarea-control textarea {
    width: 100%;
    padding: 10px 12px;
    border: 1px solid #d1d5db;
    border-radius: 6px;
    font-size: 13px;
    font-family: var(--mamba-font-mono, 'Monaco', 'Consolas', monospace);
    line-height: 1.5;
    resize: vertical;
    min-height: 80px;
    transition: border-color 0.2s ease, box-shadow 0.2s ease;
    background: #ffffff;
}

.mamba-textarea-control textarea:focus {
    outline: none;
    border-color: #E68057;
    box-shadow: 0 0 0 3px rgba(230, 128, 87, 0.1);
}

.mamba-textarea-control textarea::placeholder {
    color: #9ca3af;
    font-style: italic;
}

.mamba-field-hint {
    margin: 6px 0 0 0;
    font-size: 11px;
    color: var(--mamba-muted, #64748b);
    line-height: 1.4;
}

/* Select styling for heartbeat controls */
.mamba-select {
    width: 100%;
    padding: 8px 12px;
    border: 1px solid #d1d5db;
    border-radius: 6px;
    font-size: 13px;
    background: #ffffff;
    cursor: pointer;
    transition: border-color 0.2s ease;
}

.mamba-select:focus {
    outline: none;
    border-color: #E68057;
    box-shadow: 0 0 0 3px rgba(230, 128, 87, 0.1);
}

/* Dark theme adjustments */
[data-mamba-theme="dark"] .mamba-textarea-control textarea {
    background: var(--mamba-card, #1e293b);
    border-color: var(--mamba-border, #334155);
    color: var(--mamba-text-main, #f1f5f9);
}

[data-mamba-theme="dark"] .mamba-textarea-control textarea:focus {
    border-color: #E68057;
}

[data-mamba-theme="dark"] .mamba-select {
    background: var(--mamba-card, #1e293b);
    border-color: var(--mamba-border, #334155);
    color: var(--mamba-text-main, #f1f5f9);
}

/* Responsive Design */
@media (max-width: 1200px) {
    .mamba-optimization-grid {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .mamba-frontend-grid {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .mamba-info-cards {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 768px) {
    .mamba-performance-card {
        flex-direction: column;
        text-align: center;
        gap: 12px;
    }
    
    .mamba-optimization-grid {
        grid-template-columns: 1fr;
    }
    
    .mamba-frontend-grid {
        grid-template-columns: 1fr;
    }
    
    .mamba-info-cards {
        grid-template-columns: 1fr;
    }
    
    .mamba-optimization-header {
        flex-direction: column;
        text-align: center;
        gap: 6px;
    }
    
    .mamba-form-actions {
        flex-direction: column;
        align-items: center;
    }
}
<?php 
$__tab_css = ob_get_clean();
wp_register_style( 'mamba-tab-overhead-inline', false );
wp_enqueue_style( 'mamba-tab-overhead-inline' );
wp_add_inline_style( 'mamba-tab-overhead-inline', $__tab_css );
wp_print_styles( ['mamba-tab-overhead-inline'] );