<?php
/** @var Mamba\Support\Paths $paths */
if (!defined('ABSPATH')) exit;

// Handle cache flush actions
if (isset($_POST['mamba_object_cache_nonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['mamba_object_cache_nonce'])), 'mamba_object_cache')) {
    if (!empty($_POST['mamba_action'])) {
        $action = sanitize_key(wp_unslash($_POST['mamba_action']));
        
        switch ($action) {
            case 'flush_store_api':
                if (class_exists('\Mamba\Support\CacheAdapter')) {
                    \Mamba\Support\CacheAdapter::clearGroup('mamba_store_api');
                    echo '<div class="notice notice-success"><p>' . esc_html( __('Store API cache flushed successfully.', 'mamba-cache-for-woocommerce') ) . '</p></div>';
                }
                break;
                
            case 'flush_tags':
                if (class_exists('\Mamba\Support\CacheAdapter')) {
                    \Mamba\Support\CacheAdapter::clearGroup('mamba_tags');
                    echo '<div class="notice notice-success"><p>' . esc_html( __('Cache invalidation markers flushed successfully.', 'mamba-cache-for-woocommerce') ) . '</p></div>';
                }
                break;
                
            case 'flush_stats':
                if (class_exists('\Mamba\Support\CacheAdapter')) {
                    \Mamba\Support\CacheAdapter::clearGroup('mamba_stats');
                    echo '<div class="notice notice-success"><p>' . esc_html( __('Performance statistics reset successfully.', 'mamba-cache-for-woocommerce') ) . '</p></div>';
                }
                break;
                
            case 'flush_cart_fragments':
                if (class_exists('\Mamba\Support\CacheAdapter')) {
                    \Mamba\Support\CacheAdapter::clearGroup('mamba_cart_fragments');
                    echo '<div class="notice notice-success"><p>' . esc_html( __('Cart fragment cache cleared successfully.', 'mamba-cache-for-woocommerce') ) . '</p></div>';
                }
                break;
        }
    }
}

// Get cache status
$hasObjectCache = false;
$cacheType = 'File Cache';
$cacheStatus = 'fallback';
$cacheIcon = 'dashicons-database';
$backendInfo = [];

if (class_exists('\Mamba\Support\ObjectCache')) {
    try {
        $hasObjectCache = \Mamba\Support\ObjectCache::hasPersistentCache();
        $rawCacheType = \Mamba\Support\ObjectCache::getCacheType();
        
        if ($hasObjectCache) {
            $cacheStatus = 'active';
            $cacheIcon = 'dashicons-performance';
            
            // User-friendly cache type names
            switch (strtolower($rawCacheType)) {
                case 'redis':
                    $cacheType = 'Redis';
                    break;
                case 'memcached':
                    $cacheType = 'Memcached';
                    break;
                case 'object cache':
                    $cacheType = 'Object Cache';
                    break;
                default:
                    $cacheType = $rawCacheType;
            }
        }
        
        $backendInfo = \Mamba\Support\ObjectCache::getBackendInfo();
    } catch (Exception $e) {
        $hasObjectCache = false;
        $cacheType = 'File Cache';
        $cacheStatus = 'fallback';
        $cacheIcon = 'dashicons-database';
        $backendInfo = [
            'persistent' => false,
            'type' => 'File Cache',
            'backends' => [
                'store_api' => 'file',
                'tags' => 'file',
                'stats' => 'file',
                'cart_fragments' => 'file'
            ]
        ];
    }
}
?>

<div class="mamba-admin-wrap">
    <!-- Cache Status Overview -->
    <div class="mamba-form-section">
        <div class="mamba-section-header">
                    <h4 class="mamba-section-title">
                <span class="dashicons dashicons-performance"></span>
                <?php echo esc_html( __('Cache Backend Status', 'mamba-cache-for-woocommerce') ); ?>
            </h4>
        </div>
        
        <div class="mamba-cache-status-overview">
            <div class="mamba-cache-status-card <?php echo esc_attr($cacheStatus); ?>">
                <div class="mamba-cache-status-icon">
                    <span class="dashicons <?php echo esc_attr($cacheIcon); ?>"></span>
                </div>
                <div class="mamba-cache-status-content">
                    <h3 class="mamba-cache-status-title"><?php echo esc_html($cacheType); ?></h3>
                    <div class="mamba-cache-status-description-wrapper">
                        <p class="mamba-cache-status-description">
                            <?php if ($hasObjectCache): ?>
                                <?php echo esc_html( __('High-performance persistent cache detected. Your site is using optimized caching with automatic fallback protection.', 'mamba-cache-for-woocommerce') ); ?>
                            <?php else: ?>
                                <?php echo esc_html( __('Using reliable file-based caching. Enable Redis or Memcached for enhanced performance.', 'mamba-cache-for-woocommerce') ); ?>
                            <?php endif; ?>
                        </p>
                        <div class="mamba-cache-status-badge <?php echo esc_attr($cacheStatus); ?>">
                            <?php if ($hasObjectCache): ?>
                                <?php echo esc_html( __('Active', 'mamba-cache-for-woocommerce') ); ?>
                            <?php else: ?>
                                <?php echo esc_html( __('File Fallback', 'mamba-cache-for-woocommerce') ); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <?php if (!empty($backendInfo['backends'])): ?>
        <div class="mamba-cache-backends">
            <h4 class="mamba-backends-title"><?php echo esc_html( __('Cache Groups', 'mamba-cache-for-woocommerce') ); ?></h4>
            <p class="mamba-backends-description"><?php echo esc_html( __('Different parts of your site use specific cache groups for optimal performance and targeted invalidation.', 'mamba-cache-for-woocommerce') ); ?></p>
            
            <div class="mamba-backends-grid">
                <div class="mamba-backend-item">
                    <div class="mamba-backend-icon dashicons dashicons-rest-api"></div>
                    <div class="mamba-backend-content">
                        <h5 class="mamba-backend-name"><?php echo esc_html( __('Store API', 'mamba-cache-for-woocommerce') ); ?></h5>
                        <p class="mamba-backend-description"><?php echo esc_html( __('WooCommerce product data and catalog responses', 'mamba-cache-for-woocommerce') ); ?></p>
                        <span class="mamba-backend-type <?php echo esc_attr($backendInfo['backends']['store_api']); ?>">
                            <?php echo esc_html(ucfirst($backendInfo['backends']['store_api'])); ?>
                        </span>
                    </div>
                </div>
                
                <div class="mamba-backend-item">
                    <div class="mamba-backend-icon dashicons dashicons-admin-site"></div>
                    <div class="mamba-backend-content">
                        <h5 class="mamba-backend-name"><?php echo esc_html( __('Cache Tags', 'mamba-cache-for-woocommerce') ); ?></h5>
                        <p class="mamba-backend-description"><?php echo esc_html( __('Smart invalidation markers for targeted cache clearing', 'mamba-cache-for-woocommerce') ); ?></p>
                        <span class="mamba-backend-type <?php echo esc_attr($backendInfo['backends']['tags']); ?>">
                            <?php echo esc_html(ucfirst($backendInfo['backends']['tags'])); ?>
                        </span>
                    </div>
                </div>
                
                <div class="mamba-backend-item">
                    <div class="mamba-backend-icon dashicons dashicons-chart-bar"></div>
                    <div class="mamba-backend-content">
                        <h5 class="mamba-backend-name"><?php echo esc_html( __('Statistics', 'mamba-cache-for-woocommerce') ); ?></h5>
                        <p class="mamba-backend-description"><?php echo esc_html( __('Performance metrics and cache hit statistics', 'mamba-cache-for-woocommerce') ); ?></p>
                        <span class="mamba-backend-type <?php echo esc_attr($backendInfo['backends']['stats']); ?>">
                            <?php echo esc_html(ucfirst($backendInfo['backends']['stats'])); ?>
                        </span>
                    </div>
                </div>
                
                <div class="mamba-backend-item">
                    <div class="mamba-backend-icon dashicons dashicons-cart"></div>
                    <div class="mamba-backend-content">
                        <h5 class="mamba-backend-name"><?php echo esc_html( __('Cart Fragments', 'mamba-cache-for-woocommerce') ); ?></h5>
                        <p class="mamba-backend-description"><?php echo esc_html( __('Guest cart data for improved user experience', 'mamba-cache-for-woocommerce') ); ?></p>
                        <span class="mamba-backend-type <?php echo esc_attr($backendInfo['backends']['cart_fragments']); ?>">
                            <?php echo esc_html(ucfirst($backendInfo['backends']['cart_fragments'])); ?>
                        </span>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Cache Management -->
    <div class="mamba-form-section">
        <div class="mamba-section-header">
            <h4 class="mamba-section-title">
                <span class="dashicons dashicons-update"></span>
                <?php echo esc_html( __('Cache Management', 'mamba-cache-for-woocommerce') ); ?>
            </h4>
        </div>
        
        <div class="mamba-cache-management">
                <div class="mamba-management-intro">
                <h4 class="mamba-management-title"><?php echo esc_html( __('Targeted Cache Clearing', 'mamba-cache-for-woocommerce') ); ?></h4>
                <p class="mamba-management-description">
                    <?php echo esc_html( __('Safely clear specific cache groups without affecting other plugins or your entire site. This is the recommended approach for troubleshooting or when you need to refresh specific data.', 'mamba-cache-for-woocommerce') ); ?>
                </p>
            </div>
            
            <form method="post" class="mamba-cache-flush-form">
                <?php wp_nonce_field('mamba_object_cache', 'mamba_object_cache_nonce'); ?>
                
                <div class="mamba-flush-actions">
                    <div class="mamba-flush-action">
                        <div class="mamba-flush-action-header">
                            <div class="mamba-flush-action-icon dashicons dashicons-rest-api"></div>
                            <div class="mamba-flush-action-content">
                                <h5 class="mamba-flush-action-title"><?php echo esc_html( __('Store API Cache', 'mamba-cache-for-woocommerce') ); ?></h5>
                                <p class="mamba-flush-action-description"><?php echo esc_html( __('Use when product information changes.', 'mamba-cache-for-woocommerce') ); ?></p>
                            </div>
                        </div>
                        <button type="submit" name="mamba_action" value="flush_store_api" class="mamba-flush-button">
                            <span class="dashicons dashicons-update"></span>
                            <?php echo esc_html( __('Clear Store API', 'mamba-cache-for-woocommerce') ); ?>
                        </button>
                    </div>
                    
                    <div class="mamba-flush-action">
                        <div class="mamba-flush-action-header">
                            <div class="mamba-flush-action-icon dashicons dashicons-admin-site"></div>
                            <div class="mamba-flush-action-content">
                                <h5 class="mamba-flush-action-title"><?php echo esc_html( __('Cache Tags', 'mamba-cache-for-woocommerce') ); ?></h5>
                                <p class="mamba-flush-action-description"><?php echo esc_html( __('Use when cache clearing seems stuck.', 'mamba-cache-for-woocommerce') ); ?></p>
                            </div>
                        </div>
                        <button type="submit" name="mamba_action" value="flush_tags" class="mamba-flush-button">
                            <span class="dashicons dashicons-update"></span>
                            <?php echo esc_html( __('Clear Tags', 'mamba-cache-for-woocommerce') ); ?>
                        </button>
                    </div>
                    
                    <div class="mamba-flush-action">
                        <div class="mamba-flush-action-header">
                            <div class="mamba-flush-action-icon dashicons dashicons-chart-bar"></div>
                            <div class="mamba-flush-action-content">
                                <h5 class="mamba-flush-action-title"><?php echo esc_html( __('Statistics', 'mamba-cache-for-woocommerce') ); ?></h5>
                                <p class="mamba-flush-action-description"><?php echo esc_html( __('Use to start fresh with statistics.', 'mamba-cache-for-woocommerce') ); ?></p>
                            </div>
                        </div>
                        <button type="submit" name="mamba_action" value="flush_stats" class="mamba-flush-button">
                            <span class="dashicons dashicons-update"></span>
                            <?php echo esc_html( __('Reset Stats', 'mamba-cache-for-woocommerce') ); ?>
                        </button>
                    </div>
                    
                    <div class="mamba-flush-action">
                        <div class="mamba-flush-action-header">
                            <div class="mamba-flush-action-icon dashicons dashicons-cart"></div>
                            <div class="mamba-flush-action-content">
                                <h5 class="mamba-flush-action-title"><?php echo esc_html( __('Cart Fragments', 'mamba-cache-for-woocommerce') ); ?></h5>
                                <p class="mamba-flush-action-description"><?php echo esc_html( __('Use when cart functionality seems stuck.', 'mamba-cache-for-woocommerce') ); ?></p>
                            </div>
                        </div>
                        <button type="submit" name="mamba_action" value="flush_cart_fragments" class="mamba-flush-button">
                            <span class="dashicons dashicons-update"></span>
                            <?php echo esc_html( __('Clear Cart Cache', 'mamba-cache-for-woocommerce') ); ?>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Information Section -->
    <div class="mamba-form-section">
        <div class="mamba-section-header">

        </div>
        
        <div class="mamba-info-cards">
            <div class="mamba-info-card">
                <div class="mamba-info-icon dashicons dashicons-shield"></div>
                <h5 class="mamba-info-title"><?php echo esc_html( __('Safe & Targeted', 'mamba-cache-for-woocommerce') ); ?></h5>
                <p class="mamba-info-description"><?php echo esc_html( __('These actions only clear Mamba\'s cache data, leaving other plugins and WordPress core cache untouched.', 'mamba-cache-for-woocommerce') ); ?></p>
            </div>
            
            <div class="mamba-info-card">
                <div class="mamba-info-icon dashicons dashicons-performance"></div>
                <h5 class="mamba-info-title"><?php echo esc_html( __('Performance Optimized', 'mamba-cache-for-woocommerce') ); ?></h5>
                <p class="mamba-info-description"><?php echo esc_html( __('Each cache group serves a specific purpose, allowing for precise control over what gets cleared and when.', 'mamba-cache-for-woocommerce') ); ?></p>
            </div>
            
            <div class="mamba-info-card">
                <div class="mamba-info-icon dashicons dashicons-update"></div>
                <h5 class="mamba-info-title"><?php echo esc_html( __('Automatic Recovery', 'mamba-cache-for-woocommerce') ); ?></h5>
                <p class="mamba-info-description"><?php echo esc_html( __('Cache is automatically rebuilt as visitors browse your site, ensuring optimal performance is maintained.', 'mamba-cache-for-woocommerce') ); ?></p>
            </div>
        </div>
    </div>
</div>

<?php
ob_start();
?>

/* Cache Status Overview Section */
.mamba-cache-status-overview {
    margin-bottom: 30px;
}

.mamba-cache-status-card {
    display: flex;
    align-items: center;
    gap: 20px;
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    padding: 20px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    width: 100%;
    max-width: -webkit-fill-available;
}

.mamba-cache-status-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
}

.mamba-cache-status-card.active {
    border-color: rgba(104, 186, 127, 0.3);
    background: rgba(104, 186, 127, 0.02);
}

.mamba-cache-status-card.fallback {
    border-color: rgba(100, 116, 139, 0.3);
    background: rgba(100, 116, 139, 0.02);
}

.mamba-cache-status-icon {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 48px;
    height: 48px;
    border-radius: 8px;
    background: linear-gradient(135deg, #E68057 0%, #E6704D 100%);
    box-shadow: 0 2px 8px rgba(230, 128, 87, 0.2);
}

.mamba-cache-status-card.active .mamba-cache-status-icon {
    background: linear-gradient(135deg, #68BA7F 0%, #5aa06f 100%);
    box-shadow: 0 2px 8px rgba(104, 186, 127, 0.2);
}

.mamba-cache-status-icon .dashicons {
    font-size: 20px;
    width: 20px;
    height: 20px;
    color: #ffffff;
}

.mamba-cache-status-content {
    flex: 1;
}

.mamba-cache-status-title {
    margin: 0 0 6px 0;
    font-size: 16px;
    font-weight: 500;
    color: var(--mamba-dark);
}

.mamba-cache-status-description-wrapper {
    display: flex;
    align-items: flex-start;
    justify-content: space-between;
    gap: 12px;
    margin: 0 0 8px 0;
}

.mamba-cache-status-description {
    margin: 0;
    color: var(--mamba-muted);
    line-height: 1.4;
    font-size: 13px;
    flex: 1;
}

.mamba-cache-status-badge {
    display: inline-flex;
    align-items: center;
    padding: 3px 8px;
    border-radius: 4px;
    font-size: 0.5625rem;
    font-weight: 500;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    flex-shrink: 0;
    white-space: nowrap;
}

.mamba-cache-status-badge.active {
    background: linear-gradient(135deg, #68BA7F 0%, #5aa06f 100%);
    color: #ffffff;
}

.mamba-cache-status-badge.fallback {
    background: linear-gradient(135deg, #64748b 0%, #475569 100%);
    color: #ffffff;
}

/* Cache Backends Section */
.mamba-cache-backends {
    margin-top: 30px;
}

.mamba-backends-title {
    margin: 0 0 6px 0;
    font-size: 14px;
    font-weight: 500;
    color: var(--mamba-dark);
}

.mamba-backends-description {
    margin: 0 0 16px 0;
    color: var(--mamba-muted);
    font-size: 13px;
    line-height: 1.4;
}

.mamba-backends-grid {
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 16px;
}

.mamba-backend-item {
    display: flex;
    align-items: flex-start;
    gap: 10px;
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    padding: 16px;
    transition: all 0.3s ease;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
}

.mamba-backend-item:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.mamba-backend-icon {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 32px;
    height: 32px;
    border-radius: 6px;
    background: linear-gradient(135deg, #E68057 0%, #E6704D 100%);
    color: #ffffff;
    font-size: 14px;
    flex-shrink: 0;
}

.mamba-backend-content {
    flex: 1;
}

.mamba-backend-name {
    margin: 0 0 3px 0;
    font-size: 13px;
    font-weight: 500;
    color: var(--mamba-dark);
}

.mamba-backend-description {
    margin: 0 0 6px 0;
    font-size: 11px;
    color: var(--mamba-muted);
    line-height: 1.3;
}

.mamba-backend-type {
    display: inline-block;
    padding: 2px 6px;
    border-radius: 3px;
    font-size: 0.5rem;
    font-weight: 500;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.mamba-backend-type.redis {
    background: linear-gradient(135deg, #dc2626 0%, #b91c1c 100%);
    color: #ffffff;
}

.mamba-backend-type.memcached {
    background: linear-gradient(135deg, #fd7e14 0%, #e8590c 100%);
    color: #ffffff;
}

.mamba-backend-type.object_cache {
    background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
    color: #ffffff;
}

.mamba-backend-type.file {
    background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
    color: #ffffff;
}

/* Cache Management Section */
.mamba-cache-management {
    margin-top: 30px;
}

.mamba-management-intro {
    margin-bottom: 20px;
}

.mamba-management-title {
    margin: 0 0 6px 0;
    font-size: 14px;
    font-weight: 500;
    color: var(--mamba-dark);
}

.mamba-management-description {
    margin: 0;
    color: var(--mamba-muted);
    font-size: 13px;
    line-height: 1.4;
}

.mamba-cache-flush-form {
    margin-top: 16px;
}

.mamba-flush-actions {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 16px;
}

.mamba-flush-action {
    display: flex;
    flex-direction: column;
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    padding: 16px;
    transition: all 0.3s ease;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
}

.mamba-flush-action:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.mamba-flush-action-header {
    display: flex;
    align-items: flex-start;
    gap: 10px;
    margin-bottom: 12px;
}

.mamba-flush-action-icon {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 28px;
    height: 28px;
    border-radius: 6px;
    background: linear-gradient(135deg, #E68057 0%, #E6704D 100%);
    color: #ffffff;
    font-size: 12px;
    flex-shrink: 0;
}

.mamba-flush-action-content {
    flex: 1;
}

.mamba-flush-action-title {
    margin: 0 0 3px 0;
    font-size: 12px;
    font-weight: 500;
    color: var(--mamba-dark);
}

.mamba-flush-action-description {
    margin: 0;
    font-size: 11px;
    color: var(--mamba-muted);
    line-height: 1.3;
    min-height: 32px;
    display: flex;
    align-items: flex-start;
}

.mamba-flush-button {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 6px;
    width: 100%;
    padding: 8px 12px;
    background: linear-gradient(135deg, #E68057 0%, #E6704D 100%);
    border: none;
    border-radius: 4px;
    color: #ffffff;
    font-size: 12px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 1px 4px rgba(230, 128, 87, 0.2);
}

.mamba-flush-button:hover {
    background: linear-gradient(135deg, #d45a3a 0%, #c24a2a 100%);
    transform: translateY(-1px);
    box-shadow: 0 2px 8px rgba(230, 128, 87, 0.3);
}

.mamba-flush-button .dashicons {
    font-size: 12px;
    width: 12px;
    height: 12px;
}

/* Information Cards */
.mamba-info-cards {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 16px;
    margin: 20px 0;
}

.mamba-info-card {
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    padding: 16px;
    text-align: center;
    transition: all 0.3s ease;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
}

.mamba-info-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.mamba-info-icon {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    border-radius: 8px;
    background: linear-gradient(135deg, #E68057 0%, #E6704D 100%);
    color: #ffffff;
    font-size: 16px;
    margin-bottom: 10px;
}

.mamba-info-title {
    margin: 0 0 6px 0;
    font-size: 12px;
    font-weight: 500;
    color: var(--mamba-dark);
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.mamba-info-description {
    margin: 0;
    font-size: 11px;
    color: var(--mamba-muted);
    line-height: 1.3;
}

/* Responsive Design */
@media (max-width: 1200px) {
    .mamba-backends-grid {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .mamba-flush-actions {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 768px) {
    .mamba-cache-status-card {
        flex-direction: column;
        text-align: center;
        gap: 12px;
    }
    
    .mamba-backends-grid {
        grid-template-columns: 1fr;
    }
    
    .mamba-flush-actions {
        grid-template-columns: 1fr;
    }
    
    .mamba-info-cards {
        grid-template-columns: 1fr;
    }
    
    .mamba-cache-status-description-wrapper {
        flex-direction: column;
        align-items: center;
        gap: 8px;
    }
}
<?php
$__tab_css = ob_get_clean();
wp_register_style('mamba-tab-objectcache-inline', false);
wp_enqueue_style('mamba-tab-objectcache-inline');
wp_add_inline_style('mamba-tab-objectcache-inline', $__tab_css);
wp_print_styles(['mamba-tab-objectcache-inline']);
?>
