<?php

/** @var Mamba\Support\Paths $paths */
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
// Handle form submissions
if ( isset( $_POST['mamba_cache_settings_nonce'] ) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['mamba_cache_settings_nonce'] ) ), 'mamba_cache_settings' ) ) {
    // First, handle the purge action if that's what was requested
    if ( !empty( $_POST['mamba_action'] ) && sanitize_text_field( wp_unslash( $_POST['mamba_action'] ) ) === 'purge' ) {
        \Mamba\Modules\Caching\Services\Invalidation::clearAll();
        \Mamba\Modules\Caching\Services\Invalidation::clearStoreApi();
        // Note: clearAll() and clearStoreApi() handle cache invalidation
        echo '<div class="notice notice-success"><p>' . esc_html( __( 'Cache purged successfully.', 'mamba-cache-for-woocommerce' ) ) . '</p></div>';
    } else {
        $enabled = ( isset( $_POST['mamba_enable_page_cache'] ) ? 1 : 0 );
        $ttl = max( 60, (int) wp_unslash( $_POST['mamba_cache_ttl'] ?? 7200 ) );
        // 2 hours default
        $browserTtl = max( 0, (int) wp_unslash( $_POST['mamba_browser_ttl'] ?? 300 ) );
        // 5 minutes default
        $storeApiBrowserTtl = max( 0, (int) wp_unslash( $_POST['mamba_store_api_browser_ttl'] ?? 300 ) );
        // 5 minutes default
        $storeApiTtl = max( 60, (int) wp_unslash( $_POST['mamba_store_api_ttl'] ?? 600 ) );
        $includeAcceptLanguageVary = ( isset( $_POST['mamba_include_accept_language_vary'] ) ? 1 : 0 );
        $cdnTtl = max( 60, (int) wp_unslash( $_POST['mamba_cdn_ttl'] ?? 7200 ) );
        // 2 hours default
        $staleIfError = max( 60, (int) wp_unslash( $_POST['mamba_stale_if_error'] ?? 86400 ) );
        // 24 hours default
        $adaptiveTtl = ( isset( $_POST['mamba_enable_adaptive_ttl'] ) ? 1 : 0 );
        // Convert form input from MB to bytes before validation
        // Pro users: 10MB minimum, no upper limit (0 = unlimited)
        // Free users: Fixed at 200MB
        $inputMB = (int) wp_unslash( $_POST['mamba_cache_size_limit'] ?? 200 );
        // Free: Fixed at 200MB
        $cacheSizeLimit = 200 * 1024 * 1024;
        // Store API cache enable (Premium only)
        $storeApiCacheEnabled = 0;
        if ( mamba_fs()->can_use_premium_code__premium_only() && isset( $_POST['mamba_enable_store_api_cache'] ) ) {
            $storeApiCacheEnabled = 1;
        }
        update_option( 'mamba_enable_page_cache', $enabled );
        update_option( 'mamba_enable_store_api_cache', $storeApiCacheEnabled );
        update_option( 'mamba_cache_ttl', $ttl );
        update_option( 'mamba_browser_ttl', $browserTtl );
        update_option( 'mamba_store_api_browser_ttl', $storeApiBrowserTtl );
        update_option( 'mamba_store_api_ttl', $storeApiTtl );
        update_option( 'mamba_include_accept_language_vary', $includeAcceptLanguageVary );
        update_option( 'mamba_cdn_ttl', $cdnTtl );
        update_option( 'mamba_stale_if_error', $staleIfError );
        update_option( 'mamba_enable_adaptive_ttl', $adaptiveTtl );
        update_option( 'mamba_cache_size_limit', $cacheSizeLimit );
        // Warmup settings (saved with main form)
        $concurrency = max( 1, min( 20, (int) wp_unslash( $_POST['mamba_preload_concurrency'] ?? 5 ) ) );
        $batchSize = max( 1, min( 100, (int) wp_unslash( $_POST['mamba_warmup_batch_size'] ?? 25 ) ) );
        update_option( 'mamba_preload_concurrency', $concurrency );
        update_option( 'mamba_warmup_batch_size', $batchSize );
        // Premium warmup settings
        if ( function_exists( 'mamba_fs' ) && mamba_fs()->can_use_premium_code__premium_only() ) {
            update_option( 'mamba_warmup_priority_mode', ( isset( $_POST['mamba_warmup_priority_mode'] ) ? 1 : 0 ) );
            update_option( 'mamba_warmup_selective_mode', ( isset( $_POST['mamba_warmup_selective_mode'] ) ? 1 : 0 ) );
            update_option( 'mamba_warmup_schedule_enabled', ( isset( $_POST['mamba_warmup_schedule_enabled'] ) ? 1 : 0 ) );
            update_option( 'mamba_warmup_schedule_time', sanitize_text_field( wp_unslash( $_POST['mamba_warmup_schedule_time'] ?? '03:00' ) ) );
            // Selected categories (multi-select array)
            $selectedCatsArray = ( isset( $_POST['mamba_warmup_selected_categories'] ) ? array_filter( array_map( 'intval', (array) wp_unslash( $_POST['mamba_warmup_selected_categories'] ) ) ) : [] );
            update_option( 'mamba_warmup_selected_categories', $selectedCatsArray );
            // Selected products (multi-select array)
            $selectedProdsArray = ( isset( $_POST['mamba_warmup_selected_products'] ) ? array_filter( array_map( 'intval', (array) wp_unslash( $_POST['mamba_warmup_selected_products'] ) ) ) : [] );
            update_option( 'mamba_warmup_selected_products', $selectedProdsArray );
            // Exclusion patterns (one per line)
            $exclusions = ( isset( $_POST['mamba_warmup_exclusions'] ) ? sanitize_textarea_field( wp_unslash( $_POST['mamba_warmup_exclusions'] ) ) : '' );
            $exclusionsArray = array_filter( array_map( 'trim', explode( "\n", $exclusions ) ) );
            update_option( 'mamba_warmup_exclusions', $exclusionsArray );
            // Re-initialize scheduled warmup with new settings
            \Mamba\Modules\Caching\Services\Preload\Preloader::initScheduledWarmup();
        }
        echo '<div class="notice notice-success"><p>' . esc_html( __( 'Settings saved successfully.', 'mamba-cache-for-woocommerce' ) ) . '</p></div>';
    }
}
// Get current settings
$enabled = (bool) get_option( 'mamba_enable_page_cache', 0 );
$storeApiCacheEnabled = (bool) get_option( 'mamba_enable_store_api_cache', 0 );
$ttl = (int) get_option( 'mamba_cache_ttl', 7200 );
// 2 hours default
$adaptiveTtl = (bool) get_option( 'mamba_enable_adaptive_ttl', 0 );
$browserTtl = (int) get_option( 'mamba_browser_ttl', 300 );
// 5 minutes default
$storeApiBrowserTtl = (int) get_option( 'mamba_store_api_browser_ttl', 300 );
// 5 minutes default
$storeApiTtl = (int) get_option( 'mamba_store_api_ttl', 600 );
$includeAcceptLanguageVary = (bool) get_option( 'mamba_include_accept_language_vary', true );
$cdnTtl = (int) get_option( 'mamba_cdn_ttl', 7200 );
// 2 hours default
$staleIfError = (int) get_option( 'mamba_stale_if_error', 86400 );
// 24 hours default
$cacheSizeLimit = (int) get_option( 'mamba_cache_size_limit', 200 * 1024 * 1024 );
// Get warmup settings
$concurrency = (int) get_option( 'mamba_preload_concurrency', 5 );
$batchSize = (int) get_option( 'mamba_warmup_batch_size', 25 );
// Premium warmup settings
$priorityMode = (bool) get_option( 'mamba_warmup_priority_mode', 0 );
$selectiveMode = (bool) get_option( 'mamba_warmup_selective_mode', 0 );
$scheduleEnabled = (bool) get_option( 'mamba_warmup_schedule_enabled', 0 );
$scheduleTime = get_option( 'mamba_warmup_schedule_time', '03:00' );
$selectedCategoriesArray = (array) get_option( 'mamba_warmup_selected_categories', [] );
$selectedProductsArray = (array) get_option( 'mamba_warmup_selected_products', [] );
$exclusions = implode( "\n", (array) get_option( 'mamba_warmup_exclusions', [] ) );
?>

<form method="post" id="mamba-cache-settings-form">
    <?php 
wp_nonce_field( 'mamba_cache_settings', 'mamba_cache_settings_nonce' );
?>
    
    <div class="mamba-admin-wrap">
        <!-- Cache Overview Section -->
        <div class="mamba-cache-overview">
            <div class="mamba-cache-overview-card">
                <div class="mamba-cache-overview-icon">
                    <span class="dashicons dashicons-performance"></span>
                </div>
                <div class="mamba-cache-overview-content">
                    <h3 class="mamba-cache-overview-title"><?php 
echo esc_html( __( 'Cache Configuration Overview', 'mamba-cache-for-woocommerce' ) );
?></h3>
                    <p class="mamba-cache-overview-description"><?php 
echo esc_html( __( 'Configure page caching, Store API caching, and warmup settings for optimal WooCommerce performance.', 'mamba-cache-for-woocommerce' ) );
?></p>
                </div>
            </div>
        </div>

        <!-- Page Cache Settings -->
        <div class="mamba-form-section">
            <div class="mamba-section-header">
                <h4 class="mamba-section-title">
                    <span class="dashicons dashicons-performance"></span>
                    <?php 
echo esc_html( __( 'Page Cache Settings', 'mamba-cache-for-woocommerce' ) );
?>
                </h4>
            </div>
            
            <div class="mamba-optimization-intro">
                <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Configure page caching for WooCommerce catalog and product pages.', 'mamba-cache-for-woocommerce' ) );
?></p>
            </div>
            
            <div class="mamba-optimization-grid">
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php 
echo esc_html( __( 'Enable caching engine', 'mamba-cache-for-woocommerce' ) );
?></h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Caches WooCommerce catalog and product pages for anonymous users. Cart/Checkout/Account are always bypassed.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <div class="mamba-toggle-switch">
                        <input id="mamba_enable_page_cache" type="checkbox" name="mamba_enable_page_cache" <?php 
checked( $enabled );
?> />
                        <label for="mamba_enable_page_cache"><?php 
echo esc_html( __( 'Enable', 'mamba-cache-for-woocommerce' ) );
?></label>
                    </div>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php 
echo esc_html( __( 'Page Cache TTL (seconds)', 'mamba-cache-for-woocommerce' ) );
?></h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'How long to cache WooCommerce pages before considering them stale.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <div class="mamba-setting-control">
                        <input type="number" id="mamba_cache_ttl" name="mamba_cache_ttl" value="<?php 
echo esc_attr( $ttl );
?>" min="60" step="60" />
                    </div>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name">
                                <?php 
echo esc_html( __( 'Adaptive Cache TTL', 'mamba-cache-for-woocommerce' ) );
?>
                                <?php 
?>
                                    <span class="mamba-premium-badge">PRO</span>
                                <?php 
?>
                            </h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Dynamically adjusts TTL based on sales (shorter during flash sales) and content updates (longer for evergreen products).', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <?php 
?>
                        <div class="mamba-upgrade-btn-small">
                            <a href="<?php 
echo esc_url( mamba_fs()->get_upgrade_url() );
?>" class="button button-small button-primary"><?php 
echo esc_html( __( 'Upgrade to Enable', 'mamba-cache-for-woocommerce' ) );
?></a>
                        </div>
                    <?php 
?>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php 
echo esc_html( __( 'Browser Cache TTL (seconds)', 'mamba-cache-for-woocommerce' ) );
?></h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Fallback TTL for browser caching when page cache is not available.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <div class="mamba-setting-control">
                        <input type="number" id="mamba_browser_ttl" name="mamba_browser_ttl" value="<?php 
echo esc_attr( $browserTtl );
?>" min="0" step="30" />
                    </div>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php 
echo esc_html( __( 'Include Accept-Language in Vary Headers', 'mamba-cache-for-woocommerce' ) );
?></h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Include Accept-Language header in Vary for multilingual sites. Disable for subdomain/directory language detection to reduce cache fragmentation.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <div class="mamba-toggle-switch">
                        <input id="mamba_include_accept_language_vary" type="checkbox" name="mamba_include_accept_language_vary" <?php 
checked( $includeAcceptLanguageVary );
?> />
                        <label for="mamba_include_accept_language_vary"><?php 
echo esc_html( __( 'Enable', 'mamba-cache-for-woocommerce' ) );
?></label>
                    </div>
                </div>
            </div>
        </div>

        <!-- Store API Cache Settings (Premium) -->
        <div class="mamba-form-section">
            <div class="mamba-section-header">
                <h4 class="mamba-section-title">
                    <span class="dashicons dashicons-rest-api"></span>
                    <?php 
echo esc_html( __( 'Store API Caching', 'mamba-cache-for-woocommerce' ) );
?>
                    <?php 
?>
                        <span class="mamba-premium-badge"><?php 
echo esc_html( __( 'Premium', 'mamba-cache-for-woocommerce' ) );
?></span>
                    <?php 
?>
                </h4>
            </div>
            
            <div class="mamba-optimization-intro">
                <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Cache WooCommerce Store API responses for block-based cart, checkout, and product collections. Dramatically reduces server load and speeds up the shopping experience.', 'mamba-cache-for-woocommerce' ) );
?></p>
            </div>
            
            <?php 
?>
                <div class="mamba-premium-upsell">
                    <div class="mamba-upsell-content">
                        <span class="dashicons dashicons-lock"></span>
                        <h5><?php 
echo esc_html( __( 'Speed up your Store API', 'mamba-cache-for-woocommerce' ) );
?></h5>
                        <p><?php 
echo esc_html( __( 'Cache WooCommerce Store API responses (products, cart, checkout data) to dramatically reduce server load and speed up block-based cart and checkout. Includes smart invalidation and configurable TTLs.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        <a href="<?php 
echo esc_url( mamba_fs()->get_upgrade_url() );
?>" class="button button-primary mamba-upgrade-btn">
                            <?php 
echo esc_html( __( 'Upgrade to Pro', 'mamba-cache-for-woocommerce' ) );
?>
                        </a>
                    </div>
                </div>
            <?php 
?>
        </div>

        <!-- CDN TTL Settings -->
        <div class="mamba-form-section">
            <div class="mamba-section-header">
                <h4 class="mamba-section-title">
                    <span class="dashicons dashicons-cloud"></span>
                    <?php 
echo esc_html( __( 'CDN Cache Settings', 'mamba-cache-for-woocommerce' ) );
?>
                </h4>
            </div>
            
            <div class="mamba-optimization-intro">
                <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Configure CDN cache durations for optimal performance with CDN providers.', 'mamba-cache-for-woocommerce' ) );
?></p>
            </div>
            
            <div class="mamba-optimization-grid">
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php 
echo esc_html( __( 'CDN Cache TTL (seconds)', 'mamba-cache-for-woocommerce' ) );
?></h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'How long CDNs should cache content (s-maxage). Recommended: 7200 seconds (2 hours).', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <div class="mamba-setting-control">
                        <input type="number" id="mamba_cdn_ttl" name="mamba_cdn_ttl" value="<?php 
echo esc_attr( $cdnTtl );
?>" min="60" step="60" />
                    </div>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php 
echo esc_html( __( 'Stale-If-Error TTL (seconds)', 'mamba-cache-for-woocommerce' ) );
?></h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'How long to serve stale content when origin is unavailable. Recommended: 86400 seconds (24 hours).', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <div class="mamba-setting-control">
                        <input type="number" id="mamba_stale_if_error" name="mamba_stale_if_error" value="<?php 
echo esc_attr( $staleIfError );
?>" min="60" step="60" />
                    </div>
                </div>
            </div>
        </div>

        <!-- Cache Management (Premium) -->
        <div class="mamba-form-section">
            <div class="mamba-section-header">
                <h4 class="mamba-section-title">
                    <span class="dashicons dashicons-admin-tools"></span>
                    <?php 
echo esc_html( __( 'Cache Management', 'mamba-cache-for-woocommerce' ) );
?>
                    <?php 
?>
                        <span class="mamba-premium-badge"><?php 
echo esc_html( __( 'Premium', 'mamba-cache-for-woocommerce' ) );
?></span>
                    <?php 
?>
                </h4>
            </div>
            
            <div class="mamba-optimization-intro">
                <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Configure cache size limits and automatic cleanup thresholds to optimize disk usage and maintain peak performance.', 'mamba-cache-for-woocommerce' ) );
?></p>
            </div>
            
            <?php 
?>
                <div class="mamba-premium-upsell">
                    <div class="mamba-upsell-content">
                        <span class="dashicons dashicons-lock"></span>
                        <h5><?php 
echo esc_html( __( 'Advanced Cache Size Control', 'mamba-cache-for-woocommerce' ) );
?></h5>
                        <p><?php 
echo esc_html( __( 'Set custom cache size limits (10MB to unlimited) and automatic cleanup thresholds. Free version is fixed at 200MB.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        <a href="<?php 
echo esc_url( mamba_fs()->get_upgrade_url() );
?>" class="button button-primary mamba-upgrade-btn">
                            <?php 
echo esc_html( __( 'Upgrade to Pro', 'mamba-cache-for-woocommerce' ) );
?>
                        </a>
                    </div>
                </div>
            <?php 
?>
        </div>

        <!-- Warmup Configuration -->
        <div class="mamba-form-section">
            <div class="mamba-section-header">
                <h4 class="mamba-section-title">
                    <span class="dashicons dashicons-update"></span>
                    <?php 
echo esc_html( __( 'Cache Warmup', 'mamba-cache-for-woocommerce' ) );
?>
                </h4>
            </div>
            
            <div class="mamba-optimization-intro">
                <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Cache warmup pre-generates cached pages so visitors always get fast responses. Warmup runs automatically after cache purges and settings changes.', 'mamba-cache-for-woocommerce' ) );
?></p>
            </div>
            
            <div class="mamba-optimization-grid">
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-icon dashicons dashicons-info"></div>
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php 
echo esc_html( __( 'Automatic Warmup', 'mamba-cache-for-woocommerce' ) );
?></h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Warmup runs automatically when you enable caching, change settings, or purge the cache. No action needed.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <div class="mamba-status-indicator" style="color: #22c55e; font-weight: 500;">
                        <span class="dashicons dashicons-yes-alt" style="color: #22c55e;"></span>
                        <?php 
echo esc_html( __( 'Active', 'mamba-cache-for-woocommerce' ) );
?>
                    </div>
                </div>
                
                <?php 
?>
                <div class="mamba-optimization-item" style="grid-column: span 1;">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-icon dashicons dashicons-performance"></div>
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name">
                                <?php 
echo esc_html( __( 'Advanced Warmup Settings', 'mamba-cache-for-woocommerce' ) );
?>
                                <span class="mamba-premium-badge"><?php 
echo esc_html( __( 'Premium', 'mamba-cache-for-woocommerce' ) );
?></span>
                            </h5>
                            <p class="mamba-optimization-description"><?php 
echo esc_html( __( 'Priority warmup, scheduled warmup, selective categories/products, and URL exclusions for high-traffic stores.', 'mamba-cache-for-woocommerce' ) );
?></p>
                        </div>
                    </div>
                    <a href="<?php 
echo esc_url( mamba_fs()->get_upgrade_url() );
?>" class="button button-small button-primary" style="margin-top: 8px;">
                        <?php 
echo esc_html( __( 'Upgrade to Enable', 'mamba-cache-for-woocommerce' ) );
?>
                    </a>
                </div>
                <?php 
?>
            </div>
        </div>

        

        <div class="mamba-form-actions">
            <button class="mamba-save-button" type="submit">
                <span class="dashicons dashicons-saved"></span>
                <?php 
echo esc_html( __( 'Save All Settings', 'mamba-cache-for-woocommerce' ) );
?>
            </button>
        </div>
    </div>
</form>

<?php 
ob_start();
?>
/* Cache Overview Section */
.mamba-cache-overview {
    margin-bottom: 30px;
}

.mamba-cache-overview-card {
    display: flex;
    align-items: center;
    gap: 20px;
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    padding: 20px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    width: 100%;
    max-width: -webkit-fill-available;
    /* Match Object Cache active card accent */
    border-color: rgba(104, 186, 127, 0.3);
    background: rgba(104, 186, 127, 0.02);
}

.mamba-cache-overview-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
}

.mamba-cache-overview-icon {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 48px;
    height: 48px;
    border-radius: 8px;
    /* Match Object Cache active card icon style */
    background: linear-gradient(135deg, #68BA7F 0%, #5aa06f 100%);
    box-shadow: 0 2px 8px rgba(104, 186, 127, 0.2);
}

.mamba-cache-overview-icon .dashicons {
    font-size: 20px;
    width: 20px;
    height: 20px;
    color: #ffffff;
}

.mamba-cache-overview-content {
    flex: 1;
}

.mamba-cache-overview-title {
    margin: 0 0 6px 0;
    font-size: 16px;
    font-weight: 500;
    color: var(--mamba-dark);
}

.mamba-cache-overview-description {
    margin: 0;
    color: var(--mamba-muted);
    line-height: 1.4;
    font-size: 13px;
}

/* Align Caching tab overview title typography with Object Cache card section */
.mamba-cache-overview .mamba-cache-overview-title {
    font-size: 0.6875rem;
    font-weight: 500;
    color: var(--mamba-dark);
    margin-top: 0;
    margin-bottom: 20px;
    padding-bottom: 4px;
    border-bottom: 1px solid #e5e7eb;
    letter-spacing: 0.025em;
    text-transform: uppercase;
}

/* Optimization Sections */
.mamba-optimization-section {
    margin-bottom: 30px;
}

.mamba-optimization-intro {
    margin-bottom: 20px;
}

.mamba-optimization-title {
    display: flex;
    align-items: center;
    gap: 8px;
    margin: 0 0 6px 0;
    font-size: 14px;
    font-weight: 500;
    color: var(--mamba-dark);
    letter-spacing: 0.5px;
}

.mamba-optimization-title .dashicons {
    color: #E68057;
    font-size: 16px;
    width: 16px;
    height: 16px;
}

.mamba-optimization-description {
    margin: 0;
    color: var(--mamba-muted);
    font-size: 13px;
    line-height: 1.4;
}

/* Optimization Grid */
.mamba-optimization-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 16px;
}

.mamba-optimization-item {
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    padding: 16px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    transition: all 0.3s ease;
}

.mamba-optimization-item:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.mamba-optimization-header {
    margin-bottom: 12px;
}

.mamba-optimization-content {
    flex: 1;
}

.mamba-optimization-name {
    margin: 0 0 4px 0;
    font-size: 13px;
    font-weight: 500;
    color: var(--mamba-dark);
    letter-spacing: 0.5px;
}

.mamba-optimization-description {
    margin: 0;
    font-size: 11px;
    color: var(--mamba-muted);
    line-height: 1.3;
}

.mamba-setting-control {
    margin-top: 8px;
}

.mamba-setting-control input[type="number"] {
    width: 100%;
    padding: 8px 12px;
    border: 1px solid #d1d5db;
    border-radius: 4px;
    font-size: 13px;
    transition: border-color 0.2s ease;
    background: #ffffff;
}

.mamba-setting-control input[type="number"]:focus {
    outline: none;
    border-color: #E68057;
    box-shadow: 0 0 0 2px rgba(230, 128, 87, 0.1);
}

/* Toggle Switch Styling */
.mamba-toggle-switch {
    display: flex;
    align-items: center;
    justify-content: flex-end;
}

.mamba-toggle-switch input[type="checkbox"] {
    display: none;
}

.mamba-toggle-switch label {
    position: relative;
    padding-left: 40px;
    cursor: pointer;
    font-weight: 500;
    color: var(--mamba-text);
    font-size: 12px;
    user-select: none;
}

.mamba-toggle-switch label::before {
    content: '';
    position: absolute;
    left: 0;
    top: 50%;
    transform: translateY(-50%);
    width: 32px;
    height: 16px;
    background: linear-gradient(135deg, #e5e7eb 0%, #d1d5db 100%);
    border-radius: 4px;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    box-shadow: inset 0 1px 2px rgba(0, 0, 0, 0.1);
}

.mamba-toggle-switch label::after {
    content: '';
    position: absolute;
    left: 2px;
    top: 50%;
    transform: translateY(-50%);
    width: 12px;
    height: 12px;
    background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
    border-radius: 3px;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

.mamba-toggle-switch input[type="checkbox"]:checked + label::before {
    background: linear-gradient(135deg, #E68057 0%, #E6704D 100%);
    box-shadow: inset 0 2px 4px rgba(230, 128, 87, 0.2);
}

.mamba-toggle-switch input[type="checkbox"]:checked + label::after {
    transform: translate(16px, -50%);
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.15);
}

/* Action Buttons */
.mamba-action-buttons {
    display: flex;
    gap: 12px;
    flex-wrap: wrap;
}

.mamba-action-button {
    display: flex;
    align-items: center;
    gap: 6px;
    padding: 8px 16px;
    font-size: 12px;
    font-weight: 500;
    border: none;
    border-radius: 4px;
    cursor: pointer;
    transition: all 0.3s ease;
    text-decoration: none;
}

.mamba-action-button-primary {
    background: linear-gradient(135deg, #E68057 0%, #E6704D 100%);
    color: #ffffff;
    box-shadow: 0 1px 4px rgba(230, 128, 87, 0.2);
}

.mamba-action-button-primary:hover {
    background: linear-gradient(135deg, #d45a3a 0%, #c24a2a 100%);
    transform: translateY(-1px);
    box-shadow: 0 2px 8px rgba(230, 128, 87, 0.3);
}

.mamba-action-button-secondary {
    background: #ffffff;
    color: var(--mamba-dark);
    border: 1px solid #e5e7eb;
    box-shadow: 0 1px 4px rgba(0, 0, 0, 0.08);
}

.mamba-action-button-secondary:hover {
    background: #f9fafb;
    transform: translateY(-1px);
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.12);
}

.mamba-action-button .dashicons {
    font-size: 12px;
    width: 12px;
    height: 12px;
}

/* Form Actions */
.mamba-form-actions {
    margin-top: 30px;
    padding-top: 20px;
    border-top: 1px solid #e5e7eb;
    text-align: right;
}

.mamba-save-button {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 10px 20px;
    background: linear-gradient(135deg, #E68057 0%, #E6704D 100%);
    color: #ffffff;
    border: none;
    border-radius: 6px;
    font-size: 13px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 2px 8px rgba(230, 128, 87, 0.2);
}

.mamba-save-button:hover {
    background: linear-gradient(135deg, #d45a3a 0%, #c24a2a 100%);
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(230, 128, 87, 0.3);
}

.mamba-save-button .dashicons {
    font-size: 14px;
    width: 14px;
    height: 14px;
}

/* Responsive Design */
@media (max-width: 768px) {
    .mamba-cache-overview-card {
        flex-direction: column;
        text-align: center;
        gap: 12px;
    }
    
    .mamba-optimization-grid {
        grid-template-columns: 1fr;
    }
    
    .mamba-action-buttons {
        flex-direction: column;
    }
    
    .mamba-action-button {
        width: 100%;
        justify-content: center;
    }
    
    .mamba-form-actions {
        text-align: center;
    }
}

/* Premium Badges & Upsells */
.mamba-premium-badge {
    display: inline-block;
    background: #FFF1F0;
    color: #E03E3E;
    font-size: 10px;
    font-weight: 600;
    text-transform: uppercase;
    padding: 2px 8px;
    border-radius: 12px;
    margin-left: 8px;
    vertical-align: middle;
    border: 1px solid rgba(224, 62, 62, 0.2);
}

.mamba-premium-upsell {
    background: #F9FAFB;
    border: 1px dashed #D1D5DB;
    border-radius: 8px;
    padding: 32px 20px;
    text-align: center;
}

.mamba-upsell-content .dashicons {
    font-size: 32px;
    width: 32px;
    height: 32px;
    color: #9CA3AF;
    margin-bottom: 12px;
}

.mamba-upsell-content h5 {
    font-size: 16px;
    font-weight: 600;
    color: var(--mamba-dark);
    margin: 0 0 8px 0;
}

.mamba-upsell-content p {
    font-size: 13px;
    color: var(--mamba-muted);
    margin: 0 0 20px 0;
    max-width: 400px;
    margin-left: auto;
    margin-right: auto;
}

.mamba-upgrade-btn {
    background: linear-gradient(135deg, #10B981 0%, #059669 100%) !important; /* Green distinct from save orange */
    border: none !important;
    box-shadow: 0 2px 8px rgba(16, 185, 129, 0.2) !important;
    transition: all 0.3s ease !important;
}

.mamba-upgrade-btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(16, 185, 129, 0.3) !important;
}

/* Select2 styling for Mamba dark mode compatibility */
.mamba-admin-wrap .select2-container--default .select2-selection--multiple {
    background-color: var(--mamba-bg, #1a1a2e);
    border: 1px solid var(--mamba-border, #2d2d44);
    border-radius: 6px;
    min-height: 38px;
}

.mamba-admin-wrap .select2-container--default .select2-selection--multiple .select2-selection__choice {
    background-color: var(--mamba-primary, #6366f1);
    border: none;
    border-radius: 4px;
    color: #ffffff;
    padding: 4px 8px;
    margin: 4px;
}

.mamba-admin-wrap .select2-container--default .select2-selection--multiple .select2-selection__choice__remove {
    color: rgba(255, 255, 255, 0.7);
    margin-right: 5px;
}

.mamba-admin-wrap .select2-container--default .select2-selection--multiple .select2-selection__choice__remove:hover {
    color: #ffffff;
}

.mamba-admin-wrap .select2-container--default .select2-search--inline .select2-search__field {
    color: var(--mamba-text, #e5e7eb);
    background: transparent;
}

.mamba-admin-wrap .select2-container--default .select2-search--inline .select2-search__field::placeholder {
    color: var(--mamba-muted, #9ca3af);
}

/* Select2 dropdown styling */
.select2-container--default .select2-dropdown {
    background-color: var(--mamba-bg, #1a1a2e);
    border: 1px solid var(--mamba-border, #2d2d44);
    border-radius: 6px;
}

.select2-container--default .select2-results__option {
    color: var(--mamba-text, #e5e7eb);
    padding: 8px 12px;
}

.select2-container--default .select2-results__option--highlighted[aria-selected] {
    background-color: var(--mamba-primary, #6366f1);
    color: #ffffff;
}

.select2-container--default .select2-results__option[aria-selected=true] {
    background-color: rgba(99, 102, 241, 0.2);
    color: var(--mamba-text, #e5e7eb);
}

.select2-container--default .select2-search--dropdown .select2-search__field {
    background-color: var(--mamba-bg, #1a1a2e);
    border: 1px solid var(--mamba-border, #2d2d44);
    color: var(--mamba-text, #e5e7eb);
    border-radius: 4px;
    padding: 6px 10px;
}
<?php 
$__tab_css = ob_get_clean();
wp_register_style( 'mamba-tab-caching-inline', false );
wp_enqueue_style( 'mamba-tab-caching-inline' );
wp_add_inline_style( 'mamba-tab-caching-inline', $__tab_css );
wp_print_styles( ['mamba-tab-caching-inline'] );