<?php
/** @var Mamba\Support\Paths $paths */
if (!defined('ABSPATH')) exit;

// Handle form submissions
if (isset($_POST['mamba_cdn_settings_nonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['mamba_cdn_settings_nonce'])), 'mamba_cdn_settings')) {
    if (!current_user_can('manage_options')) {
        wp_die( esc_html( __('Unauthorized', 'mamba-cache-for-woocommerce') ) );
    }
    $provider = sanitize_text_field(wp_unslash($_POST['mamba_cdn_provider'] ?? 'disabled'));
    
    update_option('mamba_cdn_provider', $provider);
    
    // Cloudflare settings
    if ($provider === 'cloudflare') {
        update_option('mamba_cloudflare_zone_id', sanitize_text_field(wp_unslash($_POST['mamba_cloudflare_zone_id'] ?? '')), false);
        update_option('mamba_cloudflare_api_token', sanitize_text_field(wp_unslash($_POST['mamba_cloudflare_api_token'] ?? '')), false);
        update_option('mamba_cloudflare_detect_apo', isset($_POST['mamba_cloudflare_detect_apo']) ? 1 : 0);
        update_option('mamba_cloudflare_send_cache_tags', isset($_POST['mamba_cloudflare_send_cache_tags']) ? 1 : 0);
    }
    
    // Bunny settings
    if ($provider === 'bunny') {
        update_option('mamba_bunny_pull_zone_id', sanitize_text_field(wp_unslash($_POST['mamba_bunny_pull_zone_id'] ?? '')), false);
        update_option('mamba_bunny_api_key', sanitize_text_field(wp_unslash($_POST['mamba_bunny_api_key'] ?? '')), false);
        update_option('mamba_bunny_send_cdn_tags', isset($_POST['mamba_bunny_send_cdn_tags']) ? 1 : 0);
        update_option('mamba_bunny_use_wildcard_purges', isset($_POST['mamba_bunny_use_wildcard_purges']) ? 1 : 0);
    }
    
    // Generic webhook settings
    if ($provider === 'generic') {
        update_option('mamba_generic_webhook_url', esc_url_raw(wp_unslash($_POST['mamba_generic_webhook_url'] ?? '')), false);
        update_option('mamba_generic_webhook_secret', sanitize_text_field(wp_unslash($_POST['mamba_generic_webhook_secret'] ?? '')), false);
    }
    
    // Fastly settings
    if ($provider === 'fastly') {
        update_option('mamba_fastly_service_id', sanitize_text_field(wp_unslash($_POST['mamba_fastly_service_id'] ?? '')), false);
        update_option('mamba_fastly_api_token', sanitize_text_field(wp_unslash($_POST['mamba_fastly_api_token'] ?? '')), false);
        update_option('mamba_fastly_send_surrogate_keys', isset($_POST['mamba_fastly_send_surrogate_keys']) ? 1 : 0);
        update_option('mamba_fastly_soft_purge', isset($_POST['mamba_fastly_soft_purge']) ? 1 : 0);
    }
    
    // Asset Rewriting Settings
    update_option('mamba_cdn_enable_rewriting', isset($_POST['mamba_cdn_enable_rewriting']) ? 1 : 0);
    update_option('mamba_cdn_hostname', esc_url_raw(wp_unslash($_POST['mamba_cdn_hostname'] ?? '')));
    if (isset($_POST['mamba_cdn_dirs'])) {
        $dirs = array_filter(array_map('sanitize_text_field', explode("\n", wp_unslash($_POST['mamba_cdn_dirs']))));
        update_option('mamba_cdn_dirs', $dirs);
    }
    if (isset($_POST['mamba_cdn_exclusions'])) {
        $excls = array_filter(array_map('sanitize_text_field', explode("\n", wp_unslash($_POST['mamba_cdn_exclusions']))));
        update_option('mamba_cdn_exclusions', $excls);
    }
    
    echo '<div class="notice notice-success"><p>' . esc_html( __('CDN settings saved successfully.', 'mamba-cache-for-woocommerce') ) . '</p></div>';
}

// Get current settings
$provider = get_option('mamba_cdn_provider', 'disabled');
$cloudflareZoneId = get_option('mamba_cloudflare_zone_id', '');
$cloudflareApiToken = get_option('mamba_cloudflare_api_token', '');
$cloudflareDetectApo = (bool)get_option('mamba_cloudflare_detect_apo', true);
$cloudflareSendCacheTags = (bool)get_option('mamba_cloudflare_send_cache_tags', true);

$bunnyPullZoneId = get_option('mamba_bunny_pull_zone_id', '');
$bunnyApiKey = get_option('mamba_bunny_api_key', '');
$bunnySendCdnTags = (bool)get_option('mamba_bunny_send_cdn_tags', true);
$bunnyUseWildcardPurges = (bool)get_option('mamba_bunny_use_wildcard_purges', false);

$genericWebhookUrl = get_option('mamba_generic_webhook_url', '');
$genericWebhookSecret = get_option('mamba_generic_webhook_secret', '');

$fastlyServiceId = get_option('mamba_fastly_service_id', '');
$fastlyApiToken = get_option('mamba_fastly_api_token', '');
$fastlySendSurrogateKeys = (bool)get_option('mamba_fastly_send_surrogate_keys', true);
$fastlySoftPurge = (bool)get_option('mamba_fastly_soft_purge', true);

$cdnEnableRewriting = (bool)get_option('mamba_cdn_enable_rewriting', false);
$cdnHostname = get_option('mamba_cdn_hostname', '');
$cdnDirs = implode("\n", get_option('mamba_cdn_dirs', ['wp-content', 'wp-includes']));
$cdnExclusions = implode("\n", get_option('mamba_cdn_exclusions', ['.php', '.xml']));

// Check Cloudflare plugin status
$cloudflareStatus = \Mamba\Modules\CDN\Services\Manager::getCloudflarePluginStatus();
$cloudflarePluginActive = $cloudflareStatus['has_credentials'];
?>

<form method="post" id="mamba-cdn-settings-form">
    <?php wp_nonce_field('mamba_cdn_settings', 'mamba_cdn_settings_nonce'); ?>
    
    <div class="mamba-admin-wrap">
        <!-- CDN Overview Section -->
        <div class="mamba-form-section">
            <div class="mamba-section-header">
                <h4 class="mamba-section-title">
                    <?php echo esc_html( __('CDN Integration Overview', 'mamba-cache-for-woocommerce') ); ?>
                </h4>
            </div>
            <div class="mamba-performance-overview">
                <div class="mamba-performance-card">
                    <div class="mamba-performance-icon">
                        <span class="dashicons dashicons-networking"></span>
                    </div>
                    <div class="mamba-performance-content">
                        <h3 class="mamba-performance-title"><?php echo esc_html( __('CDN Integration', 'mamba-cache-for-woocommerce') ); ?></h3>
                        <p class="mamba-performance-description"><?php echo esc_html( __('Mirror every purge and warmup from Mamba to your CDN for optimal performance.', 'mamba-cache-for-woocommerce') ); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Provider Selection -->
        <div class="mamba-form-section">
            <div class="mamba-section-header">
                <h4 class="mamba-section-title">
                    <span class="dashicons dashicons-admin-generic"></span>
                    <?php echo esc_html( __('CDN Provider', 'mamba-cache-for-woocommerce') ); ?>
                </h4>
            </div>
            
            <div class="mamba-optimization-intro">
                <p class="mamba-optimization-description"><?php echo esc_html( __('Select your CDN provider to enable automatic cache purging and tag-based invalidation.', 'mamba-cache-for-woocommerce') ); ?></p>
            </div>
            
            <div class="mamba-optimization-grid">
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php echo esc_html( __('CDN Provider', 'mamba-cache-for-woocommerce') ); ?></h5>
                            <p class="mamba-optimization-description"><?php echo esc_html( __('Choose your CDN provider or disable CDN integration.', 'mamba-cache-for-woocommerce') ); ?></p>
                        </div>
                    </div>
                    <div class="mamba-setting-control">
                        <select id="mamba_cdn_provider" name="mamba_cdn_provider">
                            <option value="disabled" <?php selected($provider, 'disabled'); ?>><?php echo esc_html( __('Disabled', 'mamba-cache-for-woocommerce') ); ?></option>
                            <option value="cloudflare" <?php selected($provider, 'cloudflare'); ?>><?php echo esc_html( __('Cloudflare', 'mamba-cache-for-woocommerce') ); ?></option>
                            <option value="bunny" <?php selected($provider, 'bunny'); ?>><?php echo esc_html( __('Bunny.net', 'mamba-cache-for-woocommerce') ); ?></option>
                            <option value="fastly" <?php selected($provider, 'fastly'); ?>><?php echo esc_html( __('Fastly', 'mamba-cache-for-woocommerce') ); ?></option>
                            <option value="generic" <?php selected($provider, 'generic'); ?>><?php echo esc_html( __('Generic Webhook', 'mamba-cache-for-woocommerce') ); ?></option>
                        </select>
                    </div>
                </div>
            </div>
        </div>

        <!-- Cloudflare Settings -->
        <div class="mamba-form-section" id="cloudflare-settings" style="display: <?php echo esc_attr( $provider === 'cloudflare' ? 'block' : 'none' ); ?>;">
            <div class="mamba-section-header">
                <h4 class="mamba-section-title">
                    <?php echo esc_html( __('Cloudflare Settings', 'mamba-cache-for-woocommerce') ); ?>
                </h4>
            </div>
            
            <div class="mamba-optimization-intro">
                <p class="mamba-optimization-description"><?php echo esc_html( __('Configure Cloudflare integration with APO support and cache tag purging.', 'mamba-cache-for-woocommerce') ); ?></p>
            </div>
            
            <div class="mamba-optimization-grid">
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php echo esc_html( __('Zone ID', 'mamba-cache-for-woocommerce') ); ?></h5>
                            <p class="mamba-optimization-description"><?php echo esc_html( __('Your Cloudflare Zone ID (found in the Cloudflare dashboard).', 'mamba-cache-for-woocommerce') ); ?></p>
                        </div>
                    </div>
                    <div class="mamba-setting-control">
                        <input type="text" id="mamba_cloudflare_zone_id" name="mamba_cloudflare_zone_id" value="<?php echo esc_attr($cloudflareZoneId); ?>" placeholder="e.g., 1234567890abcdef1234567890abcdef" />
                    </div>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php echo esc_html( __('API Token', 'mamba-cache-for-woocommerce') ); ?></h5>
                            <p class="mamba-optimization-description"><?php echo esc_html( __('Cloudflare API Token with Zone → Cache Purge permissions.', 'mamba-cache-for-woocommerce') ); ?></p>
                        </div>
                    </div>
                    <div class="mamba-setting-control">
                        <input type="text" id="mamba_cloudflare_api_token" name="mamba_cloudflare_api_token" value="<?php echo esc_attr($cloudflareApiToken); ?>" placeholder="API Token" />
                    </div>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php echo esc_html( __('Detect APO & Include Cache-Key Headers', 'mamba-cache-for-woocommerce') ); ?></h5>
                            <p class="mamba-optimization-description"><?php echo esc_html( __('Automatically detect APO and include device/geo/lang headers in purges.', 'mamba-cache-for-woocommerce') ); ?></p>
                        </div>
                    </div>
                    <div class="mamba-toggle-switch">
                        <input id="mamba_cloudflare_detect_apo" type="checkbox" name="mamba_cloudflare_detect_apo" <?php checked($cloudflareDetectApo); ?> />
                        <label for="mamba_cloudflare_detect_apo"><?php echo esc_html( __('Enable', 'mamba-cache-for-woocommerce') ); ?></label>
                    </div>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php echo esc_html( __('Send Cache-Tag Headers', 'mamba-cache-for-woocommerce') ); ?></h5>
                            <p class="mamba-optimization-description"><?php echo esc_html( __('Send Cache-Tag headers on HTML/JSON responses for tag-based purging.', 'mamba-cache-for-woocommerce') ); ?></p>
                        </div>
                    </div>
                    <div class="mamba-toggle-switch">
                        <input id="mamba_cloudflare_send_cache_tags" type="checkbox" name="mamba_cloudflare_send_cache_tags" <?php checked($cloudflareSendCacheTags); ?> />
                        <label for="mamba_cloudflare_send_cache_tags"><?php echo esc_html( __('Enable', 'mamba-cache-for-woocommerce') ); ?></label>
                    </div>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                    <h5 class="mamba-optimization-name"><?php echo esc_html( __('Apply Recommended Settings', 'mamba-cache-for-woocommerce') ); ?></h5>
                            <p class="mamba-optimization-description"><?php echo esc_html( __('Apply recommended Cloudflare settings for optimal performance.', 'mamba-cache-for-woocommerce') ); ?></p>
                        </div>
                    </div>
                    <div class="mamba-setting-control">
                        <button type="button" id="apply-recommended-settings" class="button button-secondary"><?php echo esc_html( __('Apply Settings', 'mamba-cache-for-woocommerce') ); ?></button>
                        <div id="settings-result" class="mamba-test-result"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Bunny.net Settings -->
        <div class="mamba-form-section" id="bunny-settings" style="display: <?php echo esc_attr( $provider === 'bunny' ? 'block' : 'none' ); ?>;">
            <div class="mamba-section-header">
                <h4 class="mamba-section-title">
                    <?php echo esc_html( __('Bunny.net Settings', 'mamba-cache-for-woocommerce') ); ?>
                </h4>
            </div>
            
            <div class="mamba-optimization-intro">
                <p class="mamba-optimization-description"><?php echo esc_html( __('Configure Bunny.net integration with CDN-Tag support and wildcard purging.', 'mamba-cache-for-woocommerce') ); ?></p>
            </div>
            
            <div class="mamba-optimization-grid">
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php echo esc_html( __('Pull Zone ID', 'mamba-cache-for-woocommerce') ); ?></h5>
                            <p class="mamba-optimization-description"><?php echo esc_html( __('Your Bunny.net Pull Zone ID.', 'mamba-cache-for-woocommerce') ); ?></p>
                        </div>
                    </div>
                    <div class="mamba-setting-control">
                        <input type="text" id="mamba_bunny_pull_zone_id" name="mamba_bunny_pull_zone_id" value="<?php echo esc_attr($bunnyPullZoneId); ?>" placeholder="Pull Zone ID" />
                    </div>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php echo esc_html( __('API Key', 'mamba-cache-for-woocommerce') ); ?></h5>
                            <p class="mamba-optimization-description"><?php echo esc_html( __('Your Bunny.net API Key.', 'mamba-cache-for-woocommerce') ); ?></p>
                        </div>
                    </div>
                    <div class="mamba-setting-control">
                        <input type="text" id="mamba_bunny_api_key" name="mamba_bunny_api_key" value="<?php echo esc_attr($bunnyApiKey); ?>" placeholder="API Key" />
                    </div>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php echo esc_html( __('Send CDN-Tag Headers', 'mamba-cache-for-woocommerce') ); ?></h5>
                            <p class="mamba-optimization-description"><?php echo esc_html( __('Send CDN-Tag headers on HTML/JSON responses for tag-based purging.', 'mamba-cache-for-woocommerce') ); ?></p>
                        </div>
                    </div>
                    <div class="mamba-toggle-switch">
                        <input id="mamba_bunny_send_cdn_tags" type="checkbox" name="mamba_bunny_send_cdn_tags" <?php checked($bunnySendCdnTags); ?> />
                        <label for="mamba_bunny_send_cdn_tags"><?php echo esc_html( __('Enable', 'mamba-cache-for-woocommerce') ); ?></label>
                    </div>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php echo esc_html( __('Use Wildcard/Prefix Purges for Media', 'mamba-cache-for-woocommerce') ); ?></h5>
                            <p class="mamba-optimization-description"><?php echo esc_html( __('Use wildcard purges for media families (note: not available with Perma-Cache).', 'mamba-cache-for-woocommerce') ); ?></p>
                        </div>
                    </div>
                    <div class="mamba-toggle-switch">
                        <input id="mamba_bunny_use_wildcard_purges" type="checkbox" name="mamba_bunny_use_wildcard_purges" <?php checked($bunnyUseWildcardPurges); ?> />
                        <label for="mamba_bunny_use_wildcard_purges"><?php echo esc_html( __('Enable', 'mamba-cache-for-woocommerce') ); ?></label>
                    </div>
                </div>
            </div>
        </div>

        <!-- Generic Webhook Settings -->
        <div class="mamba-form-section" id="generic-settings" style="display: <?php echo esc_attr( $provider === 'generic' ? 'block' : 'none' ); ?>;">
            <div class="mamba-section-header">
                <h4 class="mamba-section-title">
                    <?php echo esc_html( __('Generic Webhook Settings', 'mamba-cache-for-woocommerce') ); ?>
                </h4>
            </div>
            
            <div class="mamba-optimization-intro">
                <p class="mamba-optimization-description"><?php echo esc_html( __('Configure webhook integration for custom CDN setups.', 'mamba-cache-for-woocommerce') ); ?></p>
            </div>
            
            <div class="mamba-optimization-grid">
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php echo esc_html( __('Webhook URL', 'mamba-cache-for-woocommerce') ); ?></h5>
                            <p class="mamba-optimization-description"><?php echo esc_html( __('The URL where purge requests will be sent.', 'mamba-cache-for-woocommerce') ); ?></p>
                        </div>
                    </div>
                    <div class="mamba-setting-control">
                        <input type="url" id="mamba_generic_webhook_url" name="mamba_generic_webhook_url" value="<?php echo esc_attr($genericWebhookUrl); ?>" placeholder="https://your-cdn.com/purge" />
                    </div>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php echo esc_html( __('Webhook Secret', 'mamba-cache-for-woocommerce') ); ?></h5>
                            <p class="mamba-optimization-description"><?php echo esc_html( __('Optional secret for webhook authentication.', 'mamba-cache-for-woocommerce') ); ?></p>
                        </div>
                    </div>
                    <div class="mamba-setting-control">
                        <input type="text" id="mamba_generic_webhook_secret" name="mamba_generic_webhook_secret" value="<?php echo esc_attr($genericWebhookSecret); ?>" placeholder="Secret Key" />
                    </div>
                </div>
            </div>
        </div>

        <!-- Fastly Settings -->
        <div class="mamba-form-section" id="fastly-settings" style="display: <?php echo esc_attr( $provider === 'fastly' ? 'block' : 'none' ); ?>;">
            <div class="mamba-section-header">
                <h4 class="mamba-section-title">
                    <?php echo esc_html( __('Fastly Settings', 'mamba-cache-for-woocommerce') ); ?>
                </h4>
            </div>
            
            <div class="mamba-optimization-intro">
                <p class="mamba-optimization-description"><?php echo esc_html( __('Configure Fastly integration with instant purge and Surrogate-Key support for WooCommerce.', 'mamba-cache-for-woocommerce') ); ?></p>
            </div>
            
            <div class="mamba-optimization-grid">
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php echo esc_html( __('Service ID', 'mamba-cache-for-woocommerce') ); ?></h5>
                            <p class="mamba-optimization-description"><?php echo esc_html( __('Your Fastly Service ID (found in the Fastly dashboard).', 'mamba-cache-for-woocommerce') ); ?></p>
                        </div>
                    </div>
                    <div class="mamba-setting-control">
                        <input type="text" id="mamba_fastly_service_id" name="mamba_fastly_service_id" value="<?php echo esc_attr($fastlyServiceId); ?>" placeholder="e.g., SU1Z0isxPaozGVKXdv0eY" />
                    </div>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php echo esc_html( __('API Token', 'mamba-cache-for-woocommerce') ); ?></h5>
                            <p class="mamba-optimization-description"><?php echo esc_html( __('Fastly API Token with purge permissions.', 'mamba-cache-for-woocommerce') ); ?></p>
                        </div>
                    </div>
                    <div class="mamba-setting-control">
                        <input type="text" id="mamba_fastly_api_token" name="mamba_fastly_api_token" value="<?php echo esc_attr($fastlyApiToken); ?>" placeholder="API Token" />
                    </div>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php echo esc_html( __('Send Surrogate-Key Headers', 'mamba-cache-for-woocommerce') ); ?></h5>
                            <p class="mamba-optimization-description"><?php echo esc_html( __('Send Surrogate-Key headers on responses for tag-based purging (product_X, category_X, etc.).', 'mamba-cache-for-woocommerce') ); ?></p>
                        </div>
                    </div>
                    <div class="mamba-toggle-switch">
                        <input id="mamba_fastly_send_surrogate_keys" type="checkbox" name="mamba_fastly_send_surrogate_keys" <?php checked($fastlySendSurrogateKeys); ?> />
                        <label for="mamba_fastly_send_surrogate_keys"><?php echo esc_html( __('Enable', 'mamba-cache-for-woocommerce') ); ?></label>
                    </div>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php echo esc_html( __('Soft Purge', 'mamba-cache-for-woocommerce') ); ?></h5>
                            <p class="mamba-optimization-description"><?php echo esc_html( __('Mark content as stale instead of removing it immediately. Serves stale content while revalidating.', 'mamba-cache-for-woocommerce') ); ?></p>
                        </div>
                    </div>
                    <div class="mamba-toggle-switch">
                        <input id="mamba_fastly_soft_purge" type="checkbox" name="mamba_fastly_soft_purge" <?php checked($fastlySoftPurge); ?> />
                        <label for="mamba_fastly_soft_purge"><?php echo esc_html( __('Enable', 'mamba-cache-for-woocommerce') ); ?></label>
                    </div>
                </div>
            </div>
        </div>

        <!-- Asset Rewriting Settings -->
        <div class="mamba-form-section">
            <div class="mamba-section-header">
                <h4 class="mamba-section-title">
                    <span class="dashicons dashicons-admin-links"></span>
                    <?php echo esc_html( __('Asset Offloading (Pull Zone)', 'mamba-cache-for-woocommerce') ); ?>
                </h4>
            </div>
            
            <div class="mamba-optimization-intro">
                <p class="mamba-optimization-description"><?php echo esc_html( __('Rewrites local asset URLs (e.g. /wp-content/...) to your CDN hostname. Required for BunnyCDN Generic/Pull Zones.', 'mamba-cache-for-woocommerce') ); ?></p>
            </div>
            
            <div class="mamba-optimization-grid">
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php echo esc_html( __('Enable Asset Rewriting', 'mamba-cache-for-woocommerce') ); ?></h5>
                            <p class="mamba-optimization-description"><?php echo esc_html( __('Rewrite image, script, and style URLs to serve from CDN.', 'mamba-cache-for-woocommerce') ); ?></p>
                        </div>
                    </div>
                    <div class="mamba-toggle-switch">
                        <input id="mamba_cdn_enable_rewriting" type="checkbox" name="mamba_cdn_enable_rewriting" <?php checked($cdnEnableRewriting); ?> />
                        <label for="mamba_cdn_enable_rewriting"><?php echo esc_html( __('Enable', 'mamba-cache-for-woocommerce') ); ?></label>
                    </div>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php echo esc_html( __('CDN Hostname', 'mamba-cache-for-woocommerce') ); ?></h5>
                            <p class="mamba-optimization-description"><?php echo esc_html( __('The hostname of your Pull Zone (e.g. https://cdn.mysite.com).', 'mamba-cache-for-woocommerce') ); ?></p>
                        </div>
                    </div>
                    <div class="mamba-setting-control">
                        <input type="url" id="mamba_cdn_hostname" name="mamba_cdn_hostname" value="<?php echo esc_attr($cdnHostname); ?>" placeholder="https://cdn.mysite.com" />
                    </div>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php echo esc_html( __('Included Directories', 'mamba-cache-for-woocommerce') ); ?></h5>
                            <p class="mamba-optimization-description"><?php echo esc_html( __('Directories to rewrite (one per line).', 'mamba-cache-for-woocommerce') ); ?></p>
                        </div>
                    </div>
                    <div class="mamba-setting-control">
                        <textarea id="mamba_cdn_dirs" name="mamba_cdn_dirs" class="mamba-code-block" rows="3"><?php echo esc_textarea($cdnDirs); ?></textarea>
                    </div>
                </div>
                
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php echo esc_html( __('Exclusions', 'mamba-cache-for-woocommerce') ); ?></h5>
                            <p class="mamba-optimization-description"><?php echo esc_html( __('Keywords/Extensions to exclude (one per line).', 'mamba-cache-for-woocommerce') ); ?></p>
                        </div>
                    </div>
                    <div class="mamba-setting-control">
                        <textarea id="mamba_cdn_exclusions" name="mamba_cdn_exclusions" class="mamba-code-block" rows="3"><?php echo esc_textarea($cdnExclusions); ?></textarea>
                    </div>
                </div>
            </div>
        </div>

        <!-- Diagnostics -->
        <div class="mamba-form-section">
            <div class="mamba-section-header">
                <h4 class="mamba-section-title">
                    <span class="dashicons dashicons-chart-bar"></span>
                    <?php echo esc_html( __('Diagnostics', 'mamba-cache-for-woocommerce') ); ?>
                </h4>
            </div>
            
            <div class="mamba-optimization-intro">
                <p class="mamba-optimization-description"><?php echo esc_html( __('Test your CDN connection and purge functionality.', 'mamba-cache-for-woocommerce') ); ?></p>
            </div>
            
            <div class="mamba-optimization-grid">
                <div class="mamba-optimization-item">
                    <div class="mamba-optimization-header">
                        <div class="mamba-optimization-content">
                            <h5 class="mamba-optimization-name"><?php echo esc_html( __('CDN Diagnostics', 'mamba-cache-for-woocommerce') ); ?></h5>
                            <p class="mamba-optimization-description"><?php echo esc_html( __('Test your CDN connection and purge functionality.', 'mamba-cache-for-woocommerce') ); ?></p>
                        </div>
                    </div>
                    <div class="mamba-setting-control">
                        <div class="mamba-diagnostics-buttons">
                            <button type="button" id="test-connection" class="mamba-diagnostic-button"><?php echo esc_html( __('Test Connection', 'mamba-cache-for-woocommerce') ); ?></button>
                            <button type="button" id="test-purge-url" class="mamba-diagnostic-button"><?php echo esc_html( __('Test URL Purge', 'mamba-cache-for-woocommerce') ); ?></button>
                            <button type="button" id="test-purge-tag" class="mamba-diagnostic-button"><?php echo esc_html( __('Test Tag Purge', 'mamba-cache-for-woocommerce') ); ?></button>
                        </div>
                        <div id="connection-result" class="mamba-test-result"></div>
                        <div id="purge-result" class="mamba-test-result"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Save Button -->
        <div class="mamba-form-section">
            <div class="mamba-setting-control">
            <button type="submit" class="button button-primary"><?php echo esc_html( __('Save CDN Settings', 'mamba-cache-for-woocommerce') ); ?></button>
            </div>
        </div>
    </div>
</form>

<?php
ob_start();
?>

.mamba-performance-overview { margin-bottom: 30px; }
.mamba-performance-card {
    display: flex;
    align-items: center;
    gap: 20px;
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    padding: 20px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    width: 100%;
    max-width: -webkit-fill-available;
}
.mamba-performance-card:hover { transform: translateY(-2px); box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12); }
.mamba-performance-icon {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 48px;
    height: 48px;
    border-radius: 8px;
    background: linear-gradient(135deg, #E68057 0%, #E6704D 100%);
    box-shadow: 0 2px 8px rgba(230, 128, 87, 0.2);
}
.mamba-performance-icon .dashicons { font-size: 20px; width: 20px; height: 20px; color: #ffffff; }
.mamba-performance-content { flex: 1; }
.mamba-performance-title { margin: 0 0 6px 0; font-size: 16px; font-weight: 500; color: var(--mamba-dark); }
.mamba-performance-description { margin: 0; color: var(--mamba-muted); line-height: 1.4; font-size: 13px; }
/* CDN Overview section – match Performance card look */
.mamba-admin-wrap > .mamba-form-section:first-of-type {
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    padding: 20px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    width: 100%;
    max-width: -webkit-fill-available;
}
.mamba-admin-wrap > .mamba-form-section:first-of-type:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
}
.mamba-code-block {
    width: 100%;
    min-height: 120px;
    font-family: 'Courier New', monospace;
    font-size: 12px;
    background: #f8f9fa;
    border: 1px solid #ddd;
    padding: 10px;
    resize: vertical;
}

.mamba-test-result {
    margin-top: 10px;
}

.mamba-test-result .notice {
    margin: 0;
    padding: 8px 12px;
}

/* Toggle Switch Styling */
.mamba-toggle-switch {
    display: flex;
    align-items: center;
    justify-content: flex-end;
}

.mamba-toggle-switch input[type="checkbox"] {
    display: none;
}

.mamba-toggle-switch label {
    position: relative;
    padding-left: 40px;
    cursor: pointer;
    font-weight: 500;
    color: var(--mamba-text);
    font-size: 12px;
    user-select: none;
}

.mamba-toggle-switch label::before {
    content: '';
    position: absolute;
    left: 0;
    top: 50%;
    transform: translateY(-50%);
    width: 32px;
    height: 16px;
    background: linear-gradient(135deg, #e5e7eb 0%, #d1d5db 100%);
    border-radius: 4px;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    box-shadow: inset 0 1px 2px rgba(0, 0, 0, 0.1);
}

.mamba-toggle-switch label::after {
    content: '';
    position: absolute;
    left: 2px;
    top: 50%;
    transform: translateY(-50%);
    width: 12px;
    height: 12px;
    background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
    border-radius: 3px;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

.mamba-toggle-switch input[type="checkbox"]:checked + label::before {
    background: linear-gradient(135deg, #E68057 0%, #E6704D 100%);
    box-shadow: inset 0 2px 4px rgba(230, 128, 87, 0.2);
}

.mamba-toggle-switch input[type="checkbox"]:checked + label::after {
    transform: translate(16px, -50%);
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.15);
}

.mamba-toggle-switch input[type="checkbox"]:disabled + label {
    opacity: 0.5;
    cursor: not-allowed;
}

/* Setting Note Styling */
.mamba-setting-note {
    display: flex;
    align-items: center;
    gap: 8px;
    margin-top: 8px;
    padding: 8px 12px;
    background: #f8f9fa;
    border: 1px solid #e9ecef;
    border-radius: 4px;
    font-size: 12px;
    color: #6c757d;
}

.mamba-setting-note .dashicons {
    color: #007cba;
    font-size: 14px;
    width: 14px;
    height: 14px;
}

/* Test Button Styling */
.mamba-setting-control .button-secondary {
    font-size: 12px;
    font-weight: 500;
    padding: 6px 12px;
    height: auto;
    line-height: 1.4;
    border-radius: 4px;
    border: 1px solid #ddd;
    background: #f8f9fa;
    color: #495057;
    transition: all 0.2s ease;
    margin-right: 8px;
    margin-bottom: 4px;
}

.mamba-setting-control .button-secondary:hover {
    background: #e9ecef;
    border-color: #adb5bd;
    color: #212529;
}

.mamba-setting-control .button-secondary:active {
    background: #dee2e6;
    border-color: #6c757d;
    transform: translateY(1px);
}

/* Ensure consistent spacing for test buttons */
.mamba-setting-control .button-secondary + .button-secondary {
    margin-left: 0;
}

/* Modern Diagnostic Buttons */
.mamba-diagnostics-buttons {
    display: flex;
    gap: 12px;
    flex-wrap: wrap;
    margin-bottom: 16px;
}

.mamba-diagnostic-button {
    background: linear-gradient(135deg, #E68057 0%, #E6704D 100%);
    color: white;
    border: none;
    padding: 10px 16px;
    border-radius: 6px;
    font-size: 13px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s ease;
    box-shadow: 0 2px 4px rgba(230, 128, 87, 0.2);
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    min-width: 120px;
    height: 36px;
}

.mamba-diagnostic-button:hover {
    background: linear-gradient(135deg, #E6704D 0%, #E66043 100%);
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(230, 128, 87, 0.3);
    color: white;
    text-decoration: none;
}

.mamba-diagnostic-button:active {
    transform: translateY(0);
    box-shadow: 0 2px 4px rgba(230, 128, 87, 0.2);
}

.mamba-diagnostic-button:disabled {
    background: #e5e7eb;
    color: #9ca3af;
    cursor: not-allowed;
    transform: none;
    box-shadow: none;
}

.mamba-diagnostic-button:disabled:hover {
    background: #e5e7eb;
    color: #9ca3af;
    transform: none;
    box-shadow: none;
}
<?php
$__tab_css = ob_get_clean();
wp_register_style('mamba-tab-cdn-inline', false);
wp_enqueue_style('mamba-tab-cdn-inline');
wp_add_inline_style('mamba-tab-cdn-inline', $__tab_css);
wp_print_styles(['mamba-tab-cdn-inline']);
?>
