<?php
/**
 * CDN Operation Result
 *
 * Represents the result of a CDN operation including success status,
 * message, data payload, and HTTP status code.
 *
 * @package Mamba\Modules\CDN\Services
 * @since   1.0.0
 */

namespace Mamba\Modules\CDN\Services;

/**
 * Class Result
 *
 * Immutable result object for CDN operations providing success/failure
 * status, messages, and optional data payload.
 *
 * @since 1.0.0
 */
final class Result {
    public function __construct(
        private bool $success,
        private string $message = '',
        private array $data = [],
        private int $statusCode = 0
    ) {}
    
    public function isSuccess(): bool {
        return $this->success;
    }
    
    public function getMessage(): string {
        return $this->message;
    }
    
    public function getData(): array {
        return $this->data;
    }
    
    public function getStatusCode(): int {
        return $this->statusCode;
    }
    
    public static function success(string $message = '', array $data = []): self {
        return new self(true, $message, $data);
    }
    
    public static function error(string $message, int $statusCode = 0, array $data = []): self {
        return new self(false, $message, $data, $statusCode);
    }
}
