<?php
if (!defined('ABSPATH')) exit;

// Status tab - cache status and system health information
$cacheEnabled = (bool)get_option('mamba_enable_page_cache', 0);

$stats = get_option('mamba_cache_stats', [
    'cache_hits' => 0,
    'cache_misses' => 0,
    'cache_size' => 0,
    'last_cleared' => 0,
    'by_type' => [
        'product' => ['hits' => 0, 'misses' => 0],
        'category' => ['hits' => 0, 'misses' => 0],
        'shop' => ['hits' => 0, 'misses' => 0],
        'store_api' => ['hits' => 0, 'misses' => 0],
        'other' => ['hits' => 0, 'misses' => 0],
        'homepage' => ['hits' => 0, 'misses' => 0]
    ]
]);

$hits = (int)($stats['cache_hits'] ?? 0);
$miss = (int)($stats['cache_misses'] ?? 0);
$byType = $stats['by_type'] ?? [];

// Calculate score excluding Store API metrics (same logic as dashboard)
$totalHits = 0;
$totalMisses = 0;

// Sum up all hits/misses except Store API
foreach ($byType as $type => $metrics) {
    if ($type !== 'store_api') {
        $totalHits += (int)($metrics['hits'] ?? 0);
        $totalMisses += (int)($metrics['misses'] ?? 0);
    }
}

// Calculate rate based on non-Store API metrics only
$rate = $cacheEnabled ? (($totalHits + $totalMisses) > 0 ? round(($totalHits / ($totalHits + $totalMisses)) * 100) : 0) : 0;

// Warmup stats
$warmupStats = get_option('mamba_warmup_stats', ['last_run'=>0,'total_urls'=>0,'success'=>0]);
$lastWarmupRun = (int)($warmupStats['last_run'] ?? 0);
$totalWarmupUrls = (int)($warmupStats['total_urls'] ?? 0);
$warmupSuccess = (int)($warmupStats['success'] ?? 0);

// System Information
$wpVersion = get_bloginfo('version');
$wcVersion = defined('WC_VERSION') ? WC_VERSION : 'Not installed';
$phpVersion = PHP_VERSION;
$serverSoftware = isset($_SERVER['SERVER_SOFTWARE']) ? sanitize_text_field(wp_unslash($_SERVER['SERVER_SOFTWARE'])) : 'Unknown';
$isApache = stripos($serverSoftware, 'apache') !== false;
$isNginx = stripos($serverSoftware, 'nginx') !== false;
$serverType = $isApache ? 'Apache' : ($isNginx ? 'Nginx' : 'Other');
$memoryLimit = ini_get('memory_limit');
$maxExecutionTime = ini_get('max_execution_time');
$uploadMaxFilesize = ini_get('upload_max_filesize');

// Theme Information
$theme = wp_get_theme();
$themeName = $theme->get('Name');
$themeVersion = $theme->get('Version');

// Database Information
global $wpdb;
$mysqlVersion = $wpdb->db_version();
$dbName = $wpdb->dbname;
$dbPrefix = $wpdb->prefix;

// Mamba Plugin Information
$mambaVersion = '1.0.0'; // 
?>
<div class="mamba-admin-wrap">
    <!-- Status Overview -->
    <div class="mamba-form-section">
        <div class="mamba-section-header">
            <h4 class="mamba-section-title">
                <span class="dashicons dashicons-chart-bar"></span>
                <?php echo esc_html( __('System Status Overview', 'mamba-cache-for-woocommerce') ); ?>
            </h4>
        </div>
        
        <div class="mamba-status-overview">
            <div class="mamba-status-card">
                <div class="mamba-status-icon">
                    <span class="dashicons dashicons-performance"></span>
                </div>
                <div class="mamba-status-content">
                    <h3 class="mamba-status-title"><?php echo esc_html( __('Performance Monitoring', 'mamba-cache-for-woocommerce') ); ?></h3>
                    <p class="mamba-status-description">
                        <?php echo esc_html( __('Monitor your cache performance, system health, and server information to ensure optimal performance for your WooCommerce store.', 'mamba-cache-for-woocommerce') ); ?>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Cache Status Section -->
    <div class="mamba-form-section">
        <div class="mamba-section-header">
            <h4 class="mamba-section-title">
                <span class="dashicons dashicons-chart-bar"></span>
                <?php echo esc_html( __('Cache Status Overview', 'mamba-cache-for-woocommerce') ); ?>
            </h4>
        </div>
        
        <div class="mamba-optimization-intro">
            <p class="mamba-optimization-description">
                <?php echo esc_html( __('Monitor your cache performance and system status to ensure optimal performance.', 'mamba-cache-for-woocommerce') ); ?>
            </p>
        </div>
        
        <div class="mamba-stats-grid">
            <div class="mamba-stat-card">
                <div class="mamba-stat-header">
                    <span class="dashicons dashicons-performance"></span>
                    <h4><?php echo esc_html( __('Cache Performance', 'mamba-cache-for-woocommerce') ); ?></h4>
                </div>
                <div class="mamba-stat-value"><?php echo esc_html($rate . '%'); ?></div>
                <div class="mamba-stat-description"><?php echo esc_html( __('Hit Rate', 'mamba-cache-for-woocommerce') ); ?></div>
                <div class="mamba-stat-details">
                    <div class="mamba-stat-detail">
                        <span class="mamba-detail-label"><?php echo esc_html( __('Total Requests:', 'mamba-cache-for-woocommerce') ); ?></span>
                        <span class="mamba-detail-value"><?php echo esc_html(number_format($hits + $miss)); ?></span>
                    </div>
                    <div class="mamba-stat-detail">
                        <span class="mamba-detail-label"><?php echo esc_html( __('Cache Hits:', 'mamba-cache-for-woocommerce') ); ?></span>
                        <span class="mamba-detail-value"><?php echo esc_html(number_format($hits)); ?></span>
                    </div>
                    <div class="mamba-stat-detail">
                        <span class="mamba-detail-label"><?php echo esc_html( __('Cache Misses:', 'mamba-cache-for-woocommerce') ); ?></span>
                        <span class="mamba-detail-value"><?php echo esc_html(number_format($miss)); ?></span>
                    </div>
                </div>
            </div>
            
            <div class="mamba-stat-card">
                <div class="mamba-stat-header">
                    <span class="dashicons dashicons-admin-tools"></span>
                    <h4><?php echo esc_html( __('System Status', 'mamba-cache-for-woocommerce') ); ?></h4>
                </div>
                <div class="mamba-stat-value <?php echo esc_attr( $cacheEnabled ? 'mamba-status-success' : 'mamba-status-warning' ); ?>">
                    <?php echo $cacheEnabled ? esc_html( __('Active', 'mamba-cache-for-woocommerce') ) : esc_html( __('Inactive', 'mamba-cache-for-woocommerce') ); ?>
                </div>
                <div class="mamba-stat-description"><?php echo esc_html( __('Cache Engine', 'mamba-cache-for-woocommerce') ); ?></div>
                <div class="mamba-stat-details">
                    <div class="mamba-stat-detail">
                        <span class="mamba-detail-label"><?php echo esc_html( __('Last Cleared:', 'mamba-cache-for-woocommerce') ); ?></span>
                        <span class="mamba-detail-value">
                            <?php 
                            $lastCleared = (int)($stats['last_cleared'] ?? 0);
                            echo $lastCleared > 0 ? esc_html(date_i18n('M j, g:i A', $lastCleared)) : esc_html( __('Never', 'mamba-cache-for-woocommerce') );
                            ?>
                        </span>
                    </div>
                    <div class="mamba-stat-detail">
                        <span class="mamba-detail-label"><?php echo esc_html( __('Cache Size:', 'mamba-cache-for-woocommerce') ); ?></span>
                        <span class="mamba-detail-value">
                            <?php 
                            $cacheSize = (int)($stats['cache_size'] ?? 0);
                            echo $cacheSize > 0 ? esc_html(size_format($cacheSize)) : esc_html( __('0 B', 'mamba-cache-for-woocommerce') );
                            ?>
                        </span>
                    </div>
                </div>
            </div>
            
            <div class="mamba-stat-card">
                <div class="mamba-stat-header">
                    <span class="dashicons dashicons-update"></span>
                    <h4><?php echo esc_html( __('Warmup Status', 'mamba-cache-for-woocommerce') ); ?></h4>
                </div>
                <div class="mamba-stat-value"><?php echo esc_html(number_format($totalWarmupUrls)); ?></div>
                <div class="mamba-stat-description"><?php echo esc_html( __('Total URLs Cached', 'mamba-cache-for-woocommerce') ); ?></div>
                <div class="mamba-stat-details">
                    <div class="mamba-stat-detail">
                        <span class="mamba-detail-label"><?php echo esc_html( __('Last Warmup:', 'mamba-cache-for-woocommerce') ); ?></span>
                        <span class="mamba-detail-value">
                            <?php 
                            echo $lastWarmupRun > 0 ? esc_html(date_i18n('M j, g:i A', $lastWarmupRun)) : esc_html( __('Never', 'mamba-cache-for-woocommerce') );
                            ?>
                        </span>
                    </div>
                    <div class="mamba-stat-detail">
                        <span class="mamba-detail-label"><?php echo esc_html( __('Success Rate:', 'mamba-cache-for-woocommerce') ); ?></span>
                        <span class="mamba-detail-value">
                            <?php 
                            $warmupRate = $totalWarmupUrls > 0 ? round(($warmupSuccess / $totalWarmupUrls) * 100) : 0;
                            echo esc_html($warmupRate . '%');
                            ?>
                        </span>
                    </div>
                    <div class="mamba-stat-detail">
                        <span class="mamba-detail-label"><?php echo esc_html( __('Failed URLs:', 'mamba-cache-for-woocommerce') ); ?></span>
                        <span class="mamba-detail-value">
                            <?php 
                            $failedUrls = $totalWarmupUrls - $warmupSuccess;
                            echo esc_html(number_format($failedUrls));
                            ?>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- System Information Section -->
    <div class="mamba-form-section">
        <div class="mamba-section-header">
            <h4 class="mamba-section-title">
                <span class="dashicons dashicons-admin-tools"></span>
                <?php echo esc_html( __('System Information', 'mamba-cache-for-woocommerce') ); ?>
            </h4>
        </div>
        
        <div class="mamba-optimization-intro">
                <p class="mamba-optimization-description">
                <?php echo esc_html( __('Detailed information about your WordPress installation, server configuration, and performance settings.', 'mamba-cache-for-woocommerce') ); ?>
            </p>
        </div>
        
        <div class="mamba-system-grid">
            <div class="mamba-system-card">
                <div class="mamba-system-header">
                    <div class="mamba-system-icon dashicons dashicons-wordpress"></div>
                    <h5 class="mamba-system-title"><?php echo esc_html( __('WordPress & WooCommerce', 'mamba-cache-for-woocommerce') ); ?></h5>
                </div>
                <div class="mamba-system-details">
                    <div class="mamba-system-detail">
                        <span class="mamba-detail-label"><?php echo esc_html( __('WordPress Version:', 'mamba-cache-for-woocommerce') ); ?></span>
                        <span class="mamba-detail-value"><?php echo esc_html($wpVersion); ?></span>
                    </div>
                    <div class="mamba-system-detail">
                        <span class="mamba-detail-label"><?php echo esc_html( __('WooCommerce Version:', 'mamba-cache-for-woocommerce') ); ?></span>
                        <span class="mamba-detail-value"><?php echo esc_html($wcVersion); ?></span>
                    </div>
                    <div class="mamba-system-detail">
                        <span class="mamba-detail-label"><?php echo esc_html( __('Active Theme:', 'mamba-cache-for-woocommerce') ); ?></span>
                        <span class="mamba-detail-value"><?php echo esc_html($themeName . ' v' . $themeVersion); ?></span>
                    </div>
                    <div class="mamba-system-detail">
                        <span class="mamba-detail-label"><?php echo esc_html( __('Mamba Version:', 'mamba-cache-for-woocommerce') ); ?></span>
                        <span class="mamba-detail-value"><?php echo esc_html($mambaVersion); ?></span>
                    </div>
                </div>
            </div>
            
            <div class="mamba-system-card">
                <div class="mamba-system-header">
                    <div class="mamba-system-icon dashicons dashicons-admin-network"></div>
                    <h5 class="mamba-system-title"><?php echo esc_html( __('Server Information', 'mamba-cache-for-woocommerce') ); ?></h5>
                </div>
                <div class="mamba-system-details">
                    <div class="mamba-system-detail">
                        <span class="mamba-detail-label"><?php echo esc_html( __('Server Software:', 'mamba-cache-for-woocommerce') ); ?></span>
                        <span class="mamba-detail-value"><?php echo esc_html($serverType); ?></span>
                    </div>
                    <div class="mamba-system-detail">
                        <span class="mamba-detail-label"><?php echo esc_html( __('PHP Version:', 'mamba-cache-for-woocommerce') ); ?></span>
                        <span class="mamba-detail-value"><?php echo esc_html($phpVersion); ?></span>
                    </div>
                    <div class="mamba-system-detail">
                        <span class="mamba-detail-label"><?php echo esc_html( __('MySQL Version:', 'mamba-cache-for-woocommerce') ); ?></span>
                        <span class="mamba-detail-value"><?php echo esc_html($mysqlVersion); ?></span>
                    </div>
                    <div class="mamba-system-detail">
                        <span class="mamba-detail-label"><?php echo esc_html( __('Database Name:', 'mamba-cache-for-woocommerce') ); ?></span>
                        <span class="mamba-detail-value"><?php echo esc_html($dbName); ?></span>
                    </div>
                </div>
            </div>
            
            <div class="mamba-system-card">
                <div class="mamba-system-header">
                    <div class="mamba-system-icon dashicons dashicons-admin-settings"></div>
                    <h5 class="mamba-system-title"><?php echo esc_html( __('Performance Settings', 'mamba-cache-for-woocommerce') ); ?></h5>
                </div>
                <div class="mamba-system-details">
                    <div class="mamba-system-detail">
                        <span class="mamba-detail-label"><?php echo esc_html( __('Memory Limit:', 'mamba-cache-for-woocommerce') ); ?></span>
                        <span class="mamba-detail-value"><?php echo esc_html($memoryLimit); ?></span>
                    </div>
                    <div class="mamba-system-detail">
                        <span class="mamba-detail-label"><?php echo esc_html( __('Max Execution Time:', 'mamba-cache-for-woocommerce') ); ?></span>
                        <span class="mamba-detail-value"><?php echo esc_html($maxExecutionTime . 's'); ?></span>
                    </div>
                    <div class="mamba-system-detail">
                        <span class="mamba-detail-label"><?php echo esc_html( __('Upload Max Filesize:', 'mamba-cache-for-woocommerce') ); ?></span>
                        <span class="mamba-detail-value"><?php echo esc_html($uploadMaxFilesize); ?></span>
                    </div>
                    <div class="mamba-system-detail">
                        <span class="mamba-detail-label"><?php echo esc_html( __('Database Prefix:', 'mamba-cache-for-woocommerce') ); ?></span>
                        <span class="mamba-detail-value"><?php echo esc_html($dbPrefix); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
ob_start();
?>

/* Status Overview Section */
.mamba-status-overview {
    margin-bottom: 30px;
}

.mamba-status-card {
    display: flex;
    align-items: center;
    gap: 20px;
    background: var(--mamba-card, #ffffff);
    border: 1px solid var(--mamba-border, #e5e7eb);
    border-radius: 8px;
    padding: 20px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    width: 100%;
    max-width: -webkit-fill-available;
}

[data-mamba-theme="dark"] .mamba-status-card {
    background: transparent !important;
    border-color: rgba(255, 255, 255, 0.06) !important;
}

.mamba-status-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
}

.mamba-status-icon {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 48px;
    height: 48px;
    border-radius: 8px;
    background: linear-gradient(135deg, #E68057 0%, #E6704D 100%);
    box-shadow: 0 2px 8px rgba(230, 128, 87, 0.2);
}

.mamba-status-icon .dashicons {
    font-size: 20px;
    width: 20px;
    height: 20px;
    color: #ffffff;
}

.mamba-status-content {
    flex: 1;
}

.mamba-status-title {
    margin: 0 0 6px 0;
    font-size: 16px;
    font-weight: 500;
    color: var(--mamba-dark);
}

.mamba-status-description {
    margin: 0;
    color: var(--mamba-muted);
    line-height: 1.4;
    font-size: 13px;
}

/* Optimization Sections */
.mamba-optimization-intro {
    margin-bottom: 20px;
}

.mamba-optimization-description {
    margin: 0;
    color: var(--mamba-muted);
    font-size: 13px;
    line-height: 1.4;
}

/* Stats Grid */
.mamba-stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 16px;
    margin: 20px 0;
}

.mamba-stat-card {
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    padding: 16px;
    text-align: center;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.mamba-stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 2px;
    background: linear-gradient(90deg, #E68057, #ff6b35);
}

.mamba-stat-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.mamba-stat-header {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 6px;
    margin-bottom: 10px;
}

.mamba-stat-header .dashicons {
    color: #E68057;
    font-size: 14px;
    width: 14px;
    height: 14px;
}

.mamba-stat-header h4 {
    margin: 0;
    font-size: 0.5625rem;
    font-weight: 500;
    color: var(--mamba-muted);
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.mamba-stat-value {
    font-size: 14px;
    font-weight: 500;
    color: var(--mamba-dark);
    margin-bottom: 3px;
    line-height: 1.2;
}

.mamba-stat-description {
    font-size: 0.625rem;
    color: var(--mamba-muted);
    font-weight: 400;
    margin-bottom: 12px;
}

.mamba-stat-details {
    border-top: 1px solid #f1f5f9;
    padding-top: 12px;
}

.mamba-stat-detail {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 6px 0;
    border-bottom: 1px solid #f8fafc;
}

.mamba-stat-detail:last-child {
    border-bottom: none;
}

.mamba-detail-label {
    font-size: 0.5625rem;
    font-weight: 500;
    color: var(--mamba-muted);
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.mamba-detail-value {
    font-size: 0.6875rem;
    font-weight: 500;
    color: var(--mamba-dark);
}

/* Status Colors */
.mamba-status-success {
    color: #68BA7F !important;
}

.mamba-status-warning {
    color: #E68057 !important;
}

/* System Grid */
.mamba-system-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
    gap: 16px;
    margin: 20px 0;
}

.mamba-system-card {
    background: #ffffff;
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    padding: 16px;
    transition: all 0.3s ease;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
}

.mamba-system-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

.mamba-system-header {
    display: flex;
    align-items: center;
    gap: 10px;
    margin-bottom: 16px;
}

.mamba-system-icon {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 32px;
    height: 32px;
    border-radius: 6px;
    background: linear-gradient(135deg, #E68057 0%, #E6704D 100%);
    color: #ffffff;
    font-size: 14px;
}

.mamba-system-title {
    margin: 0;
    font-size: 0.6875rem;
    font-weight: 500;
    color: var(--mamba-dark);
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.mamba-system-details {
    display: flex;
    flex-direction: column;
    gap: 8px;
}

.mamba-system-detail {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 8px 0;
    border-bottom: 1px solid #f8fafc;
}

.mamba-system-detail:last-child {
    border-bottom: none;
}

/* Responsive Design */
@media (max-width: 1200px) {
    .mamba-stats-grid {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .mamba-system-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 768px) {
    .mamba-status-card {
        flex-direction: column;
        text-align: center;
        gap: 12px;
    }
    
    .mamba-stats-grid {
        grid-template-columns: 1fr;
    }
    
    .mamba-system-grid {
        grid-template-columns: 1fr;
    }
    
    .mamba-system-header {
        flex-direction: column;
        text-align: center;
        gap: 6px;
    }
    
    .mamba-system-detail {
        flex-direction: column;
        align-items: flex-start;
        gap: 2px;
    }
}
<?php
$__tab_css = ob_get_clean();
wp_register_style('mamba-tab-settings-inline', false);
wp_enqueue_style('mamba-tab-settings-inline');
wp_add_inline_style('mamba-tab-settings-inline', $__tab_css);
wp_print_styles(['mamba-tab-settings-inline']);
?>