<?php

/**
 * Plugin Name: Mamba Cache for WooCommerce
 * Description: Complete WooCommerce caching & optimization — full-page + Store API cache with warmup, tag-based invalidation, CDN integration, WebP/compression, LCP optimization, and Woo DB maintenance.
 * Version: 1.0.0
 * Author: Mamba
 * Text Domain: mamba-cache-for-woocommerce
 * Requires Plugins: woocommerce
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
if ( function_exists( 'mamba_fs' ) ) {
    mamba_fs()->set_basename( false, __FILE__ );
} else {
    if ( !function_exists( 'mamba_fs' ) ) {
        // Create a helper function for easy SDK access.
        function mamba_fs() {
            global $mamba_fs;
            if ( !isset( $mamba_fs ) ) {
                // Include Freemius SDK.
                require_once dirname( __FILE__ ) . '/vendor/freemius/start.php';
                $mamba_fs = fs_dynamic_init( array(
                    'id'               => '23127',
                    'slug'             => 'mamba-cache-for-woocommerce',
                    'premium_slug'     => 'mamba-cache-premium',
                    'type'             => 'plugin',
                    'public_key'       => 'pk_898202af71ce817e6033f8bc5e082',
                    'is_premium'       => false,
                    'premium_suffix'   => 'Pro',
                    'is_premium_only'  => false,
                    'has_addons'       => false,
                    'has_paid_plans'   => true,
                    'is_org_compliant' => true,
                    'menu'             => array(
                        'slug'       => 'mamba',
                        'first-path' => 'admin.php?page=mamba&mamba_welcome=1',
                        'account'    => true,
                        'pricing'    => true,
                        'contact'    => false,
                        'support'    => false,
                        'network'    => true,
                    ),
                    'anonymous_mode'   => true,
                    'is_live'          => true,
                ) );
            }
            return $mamba_fs;
        }

        // Init Freemius.
        mamba_fs();
        // Signal that SDK was initiated.
        do_action( 'mamba_fs_loaded' );
        // Ensure uninstall cleanup runs for Freemius premium plugins
        mamba_fs()->add_action( 'after_uninstall', function () {
            Mamba\Lifecycle\Uninstaller::run();
        } );
        // Custom CSS for Freemius pricing page to match Mamba theme
        // Method 1: External CSS file via pricing/css_path filter
        mamba_fs()->add_filter( 'pricing/css_path', function ( $default_path ) {
            return dirname( __FILE__ ) . '/admin/css/freemius-pricing.css';
        } );
        // Method 2: Inline CSS via admin_enqueue_scripts for Freemius pricing page
        // Freemius Pricing Page 2.0 is a React app - CSS variables must target #fs_pricing_app
        add_action( 'admin_enqueue_scripts', function ( $hook ) {
            if ( strpos( $hook, 'mamba-pricing' ) === false && (!isset( $_GET['page'] ) || sanitize_key( wp_unslash( $_GET['page'] ) ) !== 'mamba-pricing') ) {
                return;
            }
            $pricing_css = '
            #fs_pricing_app {
                --fs-ds-theme-primary-accent-color: #10b981 !important;
                --fs-ds-theme-primary-accent-color-hover: #059669 !important;
                --fs-ds-blue-10: #ecfdf5 !important;
                --fs-ds-blue-100: #d1fae5 !important;
                --fs-ds-blue-200: #a7f3d0 !important;
                --fs-ds-blue-300: #6ee7b7 !important;
                --fs-ds-blue-400: #34d399 !important;
                --fs-ds-blue-500: #10b981 !important;
                --fs-ds-blue-600: #059669 !important;
                --fs-ds-blue-700: #047857 !important;
                --fs-ds-blue-800: #065f46 !important;
                --fs-ds-blue-900: #064e3b !important;
                --fs-ds-typography-font-family: "Inter", -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif !important;
            }
            .fs-plugin-title-and-logo {
                display: flex !important;
                flex-direction: column !important;
                align-items: center !important;
                padding: 48px 32px 40px !important;
                margin-bottom: 32px !important;
                background: linear-gradient(135deg, #0f172a 0%, #1e293b 50%, #0f172a 100%) !important;
                border-radius: 24px !important;
                border: 1px solid rgba(16, 185, 129, 0.2) !important;
                box-shadow: 0 4px 24px rgba(0, 0, 0, 0.12), 0 0 0 1px rgba(16, 185, 129, 0.1) !important;
                position: relative !important;
                overflow: hidden !important;
            }
            .fs-plugin-title-and-logo .fs-plugin-logo {
                width: 80px !important;
                height: 80px !important;
                border-radius: 20px !important;
                box-shadow: 0 8px 32px rgba(16, 185, 129, 0.3), 0 0 0 3px rgba(16, 185, 129, 0.2) !important;
                margin-bottom: 20px !important;
                position: relative !important;
                z-index: 1 !important;
            }
            .fs-plugin-title-and-logo h1 {
                font-family: "Inter", -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif !important;
                font-size: 28px !important;
                font-weight: 700 !important;
                color: #ffffff !important;
                margin: 0 !important;
                position: relative !important;
                z-index: 1 !important;
                visibility: hidden !important;
                height: 0 !important;
                overflow: hidden !important;
            }
            .fs-plugin-title-and-logo::after {
                content: "Mamba Cache for WooCommerce" !important;
                display: block !important;
                font-family: "Inter", -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif !important;
                font-size: 28px !important;
                font-weight: 700 !important;
                color: #ffffff !important;
                position: relative !important;
                z-index: 1 !important;
                letter-spacing: -0.5px !important;
            }
            .fs-plugin-title-and-logo h1 strong {
                font-weight: 700 !important;
                background: linear-gradient(135deg, #34d399 0%, #10b981 50%, #059669 100%) !important;
                -webkit-background-clip: text !important;
                -webkit-text-fill-color: transparent !important;
                background-clip: text !important;
            }
            #fs_pricing_wrapper { max-width: 1400px !important; padding: 32px 24px !important; }
            #fs_pricing, .fs-section { font-family: "Inter", -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif !important; font-size: 14px !important; }
            .fs-plans, .fs-pricing-plans, [class*="plans-container"] {
                display: grid !important;
                grid-template-columns: repeat(4, 1fr) !important;
                gap: 20px !important;
                max-width: 1320px !important;
                margin: 0 auto !important;
            }
            @media (max-width: 1200px) {
                .fs-plans, .fs-pricing-plans, [class*="plans-container"] {
                    grid-template-columns: repeat(2, 1fr) !important;
                    max-width: 700px !important;
                }
            }
            @media (max-width: 700px) {
                .fs-plans, .fs-pricing-plans, [class*="plans-container"] {
                    grid-template-columns: 1fr !important;
                }
            }';
            wp_register_style( 'mamba-freemius-pricing', false );
            wp_enqueue_style( 'mamba-freemius-pricing' );
            wp_add_inline_style( 'mamba-freemius-pricing', $pricing_css );
        } );
    }
    // Define plugin constants
    define( 'MAMBA_FILE', __FILE__ );
    define( 'MAMBA_VERSION', '1.0.0' );
    // PSR-4 autoloader for Mamba\ namespace
    spl_autoload_register( function ( $class ) {
        if ( strpos( $class, 'Mamba\\' ) !== 0 ) {
            return;
        }
        $rel = substr( $class, strlen( 'Mamba\\' ) );
        $path = __DIR__ . '/src/' . str_replace( '\\', '/', $rel ) . '.php';
        if ( file_exists( $path ) ) {
            require $path;
        }
    } );
    $plugin = new Mamba\Plugin(__FILE__);
    // Activation hook - passes $network_wide parameter for multisite support
    register_activation_hook( __FILE__, function ( $network_wide ) {
        Mamba\Lifecycle\Activator::run( (bool) $network_wide );
    } );
    // Deactivation hook - passes $network_wide parameter for multisite support
    register_deactivation_hook( __FILE__, function ( $network_wide ) {
        Mamba\Lifecycle\Deactivator::run( (bool) $network_wide );
    } );
    // Uninstall hook - doesn't receive $network_wide, so Uninstaller detects it
    register_uninstall_hook( __FILE__, [Mamba\Lifecycle\Uninstaller::class, 'run'] );
    // Register object cache global groups early for multisite compatibility
    add_action( 'plugins_loaded', function () {
        if ( class_exists( '\\Mamba\\Support\\ObjectCache' ) ) {
            \Mamba\Support\ObjectCache::registerGlobalGroups();
        }
    }, 0 );
    $plugin->boot();
    // Register WP-CLI commands if available
    if ( defined( 'WP_CLI' ) && WP_CLI ) {
        // Use autoloader to load the Commands class
        if ( class_exists( 'Mamba\\CLI\\Commands' ) ) {
            Mamba\CLI\Commands::register();
        } else {
            // Direct require fallback in case autoload path differs
            $cliPath = __DIR__ . '/src/CLI/Commands.php';
            if ( file_exists( $cliPath ) ) {
                require_once $cliPath;
                if ( class_exists( 'Mamba\\CLI\\Commands' ) ) {
                    Mamba\CLI\Commands::register();
                }
            }
        }
    }
}